"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateMachineFragment = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chain_1 = require("./chain");
const parallel_1 = require("./states/parallel");
const state_1 = require("./states/state");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * Base class for reusable state machine fragments
 */
class StateMachineFragment extends core_1.Construct {
    get id() {
        return this.node.id;
    }
    /**
     * Prefix the IDs of all states in this state machine fragment
     *
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     *
     * @param prefix The prefix to add. Will use construct ID by default.
     */
    prefixStates(prefix) {
        state_1.State.prefixStates(this, prefix || `${this.id}: `);
        return this;
    }
    /**
     * Wrap all states in this state machine fragment up into a single state.
     *
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    toSingleState(options = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_SingleStateOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.toSingleState);
            }
            throw error;
        }
        const stateId = options.stateId || this.id;
        this.prefixStates(options.prefixStates || `${stateId}: `);
        return new parallel_1.Parallel(this, stateId, options).branch(this);
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.next);
            }
            throw error;
        }
        return chain_1.Chain.start(this).next(next);
    }
}
exports.StateMachineFragment = StateMachineFragment;
_a = JSII_RTTI_SYMBOL_1;
StateMachineFragment[_a] = { fqn: "@aws-cdk/aws-stepfunctions.StateMachineFragment", version: "1.182.0" };
//# sourceMappingURL=data:application/json;base64,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