import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::DataBrew::Dataset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html
 * @external
 */
export interface CfnDatasetProps {
    /**
     * `AWS::DataBrew::Dataset.Input`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-input
     * @external
     */
    readonly input: any | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Dataset.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DataBrew::Dataset.FormatOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-formatoptions
     * @external
     */
    readonly formatOptions?: any | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Dataset.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataBrew::Dataset`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html
 * @external
 * @cloudformationResource AWS::DataBrew::Dataset
 */
export declare class CfnDataset extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataBrew::Dataset";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDataset;
    /**
     * `AWS::DataBrew::Dataset.Input`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-input
     * @external
     */
    input: any | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Dataset.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-name
     * @external
     */
    name: string;
    /**
     * `AWS::DataBrew::Dataset.FormatOptions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-formatoptions
     * @external
     */
    formatOptions: any | cdk.IResolvable | undefined;
    /**
     * `AWS::DataBrew::Dataset.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-dataset.html#cfn-databrew-dataset-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataBrew::Dataset`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDatasetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DataBrew::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html
 * @external
 */
export interface CfnJobProps {
    /**
     * `AWS::DataBrew::Job.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DataBrew::Job.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::DataBrew::Job.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::DataBrew::Job.DatasetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datasetname
     * @external
     */
    readonly datasetName?: string;
    /**
     * `AWS::DataBrew::Job.EncryptionKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionkeyarn
     * @external
     */
    readonly encryptionKeyArn?: string;
    /**
     * `AWS::DataBrew::Job.EncryptionMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionmode
     * @external
     */
    readonly encryptionMode?: string;
    /**
     * `AWS::DataBrew::Job.LogSubscription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-logsubscription
     * @external
     */
    readonly logSubscription?: string;
    /**
     * `AWS::DataBrew::Job.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxcapacity
     * @external
     */
    readonly maxCapacity?: number;
    /**
     * `AWS::DataBrew::Job.MaxRetries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxretries
     * @external
     */
    readonly maxRetries?: number;
    /**
     * `AWS::DataBrew::Job.OutputLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputlocation
     * @external
     */
    readonly outputLocation?: any | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Job.Outputs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputs
     * @external
     */
    readonly outputs?: Array<CfnJob.OutputProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Job.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-projectname
     * @external
     */
    readonly projectName?: string;
    /**
     * `AWS::DataBrew::Job.Recipe`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-recipe
     * @external
     */
    readonly recipe?: any | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Job.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::DataBrew::Job.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-timeout
     * @external
     */
    readonly timeout?: number;
}
/**
 * A CloudFormation `AWS::DataBrew::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html
 * @external
 * @cloudformationResource AWS::DataBrew::Job
 */
export declare class CfnJob extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataBrew::Job";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJob;
    /**
     * `AWS::DataBrew::Job.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-name
     * @external
     */
    name: string;
    /**
     * `AWS::DataBrew::Job.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::DataBrew::Job.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-type
     * @external
     */
    type: string;
    /**
     * `AWS::DataBrew::Job.DatasetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-datasetname
     * @external
     */
    datasetName: string | undefined;
    /**
     * `AWS::DataBrew::Job.EncryptionKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionkeyarn
     * @external
     */
    encryptionKeyArn: string | undefined;
    /**
     * `AWS::DataBrew::Job.EncryptionMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-encryptionmode
     * @external
     */
    encryptionMode: string | undefined;
    /**
     * `AWS::DataBrew::Job.LogSubscription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-logsubscription
     * @external
     */
    logSubscription: string | undefined;
    /**
     * `AWS::DataBrew::Job.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxcapacity
     * @external
     */
    maxCapacity: number | undefined;
    /**
     * `AWS::DataBrew::Job.MaxRetries`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-maxretries
     * @external
     */
    maxRetries: number | undefined;
    /**
     * `AWS::DataBrew::Job.OutputLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputlocation
     * @external
     */
    outputLocation: any | cdk.IResolvable | undefined;
    /**
     * `AWS::DataBrew::Job.Outputs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-outputs
     * @external
     */
    outputs: Array<CfnJob.OutputProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::DataBrew::Job.ProjectName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-projectname
     * @external
     */
    projectName: string | undefined;
    /**
     * `AWS::DataBrew::Job.Recipe`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-recipe
     * @external
     */
    recipe: any | cdk.IResolvable | undefined;
    /**
     * `AWS::DataBrew::Job.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::DataBrew::Job.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html#cfn-databrew-job-timeout
     * @external
     */
    timeout: number | undefined;
    /**
     * Create a new `AWS::DataBrew::Job`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataBrew::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html
 * @external
 * @cloudformationResource AWS::DataBrew::Job
 */
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html
     * @external
     */
    interface OutputProperty {
        /**
         * `CfnJob.OutputProperty.CompressionFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-compressionformat
         * @external
         */
        readonly compressionFormat?: string;
        /**
         * `CfnJob.OutputProperty.Format`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-format
         * @external
         */
        readonly format?: string;
        /**
         * `CfnJob.OutputProperty.Location`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-location
         * @external
         */
        readonly location: CfnJob.S3LocationProperty | cdk.IResolvable;
        /**
         * `CfnJob.OutputProperty.Overwrite`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-overwrite
         * @external
         */
        readonly overwrite?: boolean | cdk.IResolvable;
        /**
         * `CfnJob.OutputProperty.PartitionColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-output.html#cfn-databrew-job-output-partitioncolumns
         * @external
         */
        readonly partitionColumns?: string[];
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Job`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-job.html
 * @external
 * @cloudformationResource AWS::DataBrew::Job
 */
export declare namespace CfnJob {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnJob.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnJob.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-job-s3location.html#cfn-databrew-job-s3location-key
         * @external
         */
        readonly key?: string;
    }
}
/**
 * Properties for defining a `AWS::DataBrew::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html
 * @external
 */
export interface CfnProjectProps {
    /**
     * `AWS::DataBrew::Project.DatasetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-datasetname
     * @external
     */
    readonly datasetName: string;
    /**
     * `AWS::DataBrew::Project.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DataBrew::Project.RecipeName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-recipename
     * @external
     */
    readonly recipeName: string;
    /**
     * `AWS::DataBrew::Project.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::DataBrew::Project.Sample`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-sample
     * @external
     */
    readonly sample?: any | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataBrew::Project`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html
 * @external
 * @cloudformationResource AWS::DataBrew::Project
 */
export declare class CfnProject extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataBrew::Project";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProject;
    /**
     * `AWS::DataBrew::Project.DatasetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-datasetname
     * @external
     */
    datasetName: string;
    /**
     * `AWS::DataBrew::Project.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-name
     * @external
     */
    name: string;
    /**
     * `AWS::DataBrew::Project.RecipeName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-recipename
     * @external
     */
    recipeName: string;
    /**
     * `AWS::DataBrew::Project.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::DataBrew::Project.Sample`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-sample
     * @external
     */
    sample: any | cdk.IResolvable | undefined;
    /**
     * `AWS::DataBrew::Project.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-project.html#cfn-databrew-project-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataBrew::Project`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProjectProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 */
export interface CfnRecipeProps {
    /**
     * `AWS::DataBrew::Recipe.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DataBrew::Recipe.Steps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-steps
     * @external
     */
    readonly steps: Array<CfnRecipe.RecipeStepProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Recipe.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::DataBrew::Recipe.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare class CfnRecipe extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataBrew::Recipe";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRecipe;
    /**
     * `AWS::DataBrew::Recipe.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-name
     * @external
     */
    name: string;
    /**
     * `AWS::DataBrew::Recipe.Steps`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-steps
     * @external
     */
    steps: Array<CfnRecipe.RecipeStepProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::DataBrew::Recipe.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::DataBrew::Recipe.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html#cfn-databrew-recipe-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataBrew::Recipe`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRecipeProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-action.html
     * @external
     */
    interface ActionProperty {
        /**
         * `CfnRecipe.ActionProperty.Operation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-action.html#cfn-databrew-recipe-action-operation
         * @external
         */
        readonly operation: string;
        /**
         * `CfnRecipe.ActionProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-action.html#cfn-databrew-recipe-action-parameters
         * @external
         */
        readonly parameters?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-conditionexpression.html
     * @external
     */
    interface ConditionExpressionProperty {
        /**
         * `CfnRecipe.ConditionExpressionProperty.Condition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-conditionexpression.html#cfn-databrew-recipe-conditionexpression-condition
         * @external
         */
        readonly condition: string;
        /**
         * `CfnRecipe.ConditionExpressionProperty.TargetColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-conditionexpression.html#cfn-databrew-recipe-conditionexpression-targetcolumn
         * @external
         */
        readonly targetColumn: string;
        /**
         * `CfnRecipe.ConditionExpressionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-conditionexpression.html#cfn-databrew-recipe-conditionexpression-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-datacataloginputdefinition.html
     * @external
     */
    interface DataCatalogInputDefinitionProperty {
        /**
         * `CfnRecipe.DataCatalogInputDefinitionProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-datacataloginputdefinition.html#cfn-databrew-recipe-datacataloginputdefinition-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnRecipe.DataCatalogInputDefinitionProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-datacataloginputdefinition.html#cfn-databrew-recipe-datacataloginputdefinition-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnRecipe.DataCatalogInputDefinitionProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-datacataloginputdefinition.html#cfn-databrew-recipe-datacataloginputdefinition-tablename
         * @external
         */
        readonly tableName?: string;
        /**
         * `CfnRecipe.DataCatalogInputDefinitionProperty.TempDirectory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-datacataloginputdefinition.html#cfn-databrew-recipe-datacataloginputdefinition-tempdirectory
         * @external
         */
        readonly tempDirectory?: CfnRecipe.S3LocationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html
     * @external
     */
    interface RecipeParametersProperty {
        /**
         * `CfnRecipe.RecipeParametersProperty.AggregateFunction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-aggregatefunction
         * @external
         */
        readonly aggregateFunction?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Base`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-base
         * @external
         */
        readonly base?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CaseStatement`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-casestatement
         * @external
         */
        readonly caseStatement?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CategoryMap`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-categorymap
         * @external
         */
        readonly categoryMap?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CharsToRemove`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-charstoremove
         * @external
         */
        readonly charsToRemove?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CollapseConsecutiveWhitespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-collapseconsecutivewhitespace
         * @external
         */
        readonly collapseConsecutiveWhitespace?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.ColumnDataType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-columndatatype
         * @external
         */
        readonly columnDataType?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.ColumnRange`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-columnrange
         * @external
         */
        readonly columnRange?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Count`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-count
         * @external
         */
        readonly count?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CustomCharacters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-customcharacters
         * @external
         */
        readonly customCharacters?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CustomStopWords`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-customstopwords
         * @external
         */
        readonly customStopWords?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.CustomValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-customvalue
         * @external
         */
        readonly customValue?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.DatasetsColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-datasetscolumns
         * @external
         */
        readonly datasetsColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.DateAddValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-dateaddvalue
         * @external
         */
        readonly dateAddValue?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.DateTimeFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-datetimeformat
         * @external
         */
        readonly dateTimeFormat?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.DateTimeParameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-datetimeparameters
         * @external
         */
        readonly dateTimeParameters?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.DeleteOtherRows`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-deleteotherrows
         * @external
         */
        readonly deleteOtherRows?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Delimiter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-delimiter
         * @external
         */
        readonly delimiter?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.EndPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-endpattern
         * @external
         */
        readonly endPattern?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.EndPosition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-endposition
         * @external
         */
        readonly endPosition?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.EndValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-endvalue
         * @external
         */
        readonly endValue?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.ExpandContractions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-expandcontractions
         * @external
         */
        readonly expandContractions?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Exponent`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-exponent
         * @external
         */
        readonly exponent?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.FalseString`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-falsestring
         * @external
         */
        readonly falseString?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.GroupByAggFunctionOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-groupbyaggfunctionoptions
         * @external
         */
        readonly groupByAggFunctionOptions?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.GroupByColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-groupbycolumns
         * @external
         */
        readonly groupByColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.HiddenColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-hiddencolumns
         * @external
         */
        readonly hiddenColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.IgnoreCase`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-ignorecase
         * @external
         */
        readonly ignoreCase?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.IncludeInSplit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-includeinsplit
         * @external
         */
        readonly includeInSplit?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Input`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-input
         * @external
         */
        readonly input?: any | cdk.IResolvable;
        /**
         * `CfnRecipe.RecipeParametersProperty.Interval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-interval
         * @external
         */
        readonly interval?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.IsText`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-istext
         * @external
         */
        readonly isText?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.JoinKeys`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-joinkeys
         * @external
         */
        readonly joinKeys?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.JoinType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-jointype
         * @external
         */
        readonly joinType?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.LeftColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-leftcolumns
         * @external
         */
        readonly leftColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Limit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-limit
         * @external
         */
        readonly limit?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.LowerBound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-lowerbound
         * @external
         */
        readonly lowerBound?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.MapType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-maptype
         * @external
         */
        readonly mapType?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.ModeType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-modetype
         * @external
         */
        readonly modeType?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.MultiLine`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-multiline
         * @external
         */
        readonly multiLine?: boolean | cdk.IResolvable;
        /**
         * `CfnRecipe.RecipeParametersProperty.NumRows`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-numrows
         * @external
         */
        readonly numRows?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.NumRowsAfter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-numrowsafter
         * @external
         */
        readonly numRowsAfter?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.NumRowsBefore`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-numrowsbefore
         * @external
         */
        readonly numRowsBefore?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.OrderByColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-orderbycolumn
         * @external
         */
        readonly orderByColumn?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.OrderByColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-orderbycolumns
         * @external
         */
        readonly orderByColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Other`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-other
         * @external
         */
        readonly other?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Pattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-pattern
         * @external
         */
        readonly pattern?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.PatternOption1`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-patternoption1
         * @external
         */
        readonly patternOption1?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.PatternOption2`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-patternoption2
         * @external
         */
        readonly patternOption2?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.PatternOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-patternoptions
         * @external
         */
        readonly patternOptions?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Period`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-period
         * @external
         */
        readonly period?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Position`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-position
         * @external
         */
        readonly position?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveAllPunctuation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeallpunctuation
         * @external
         */
        readonly removeAllPunctuation?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveAllQuotes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeallquotes
         * @external
         */
        readonly removeAllQuotes?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveAllWhitespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeallwhitespace
         * @external
         */
        readonly removeAllWhitespace?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveCustomCharacters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removecustomcharacters
         * @external
         */
        readonly removeCustomCharacters?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveCustomValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removecustomvalue
         * @external
         */
        readonly removeCustomValue?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveLeadingAndTrailingPunctuation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeleadingandtrailingpunctuation
         * @external
         */
        readonly removeLeadingAndTrailingPunctuation?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveLeadingAndTrailingQuotes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeleadingandtrailingquotes
         * @external
         */
        readonly removeLeadingAndTrailingQuotes?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveLeadingAndTrailingWhitespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeleadingandtrailingwhitespace
         * @external
         */
        readonly removeLeadingAndTrailingWhitespace?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveLetters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removeletters
         * @external
         */
        readonly removeLetters?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveNumbers`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removenumbers
         * @external
         */
        readonly removeNumbers?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveSourceColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removesourcecolumn
         * @external
         */
        readonly removeSourceColumn?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RemoveSpecialCharacters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-removespecialcharacters
         * @external
         */
        readonly removeSpecialCharacters?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.RightColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-rightcolumns
         * @external
         */
        readonly rightColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SampleSize`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-samplesize
         * @external
         */
        readonly sampleSize?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SampleType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sampletype
         * @external
         */
        readonly sampleType?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SecondInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-secondinput
         * @external
         */
        readonly secondInput?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SecondaryInputs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-secondaryinputs
         * @external
         */
        readonly secondaryInputs?: Array<CfnRecipe.SecondaryInputProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnRecipe.RecipeParametersProperty.SheetIndexes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sheetindexes
         * @external
         */
        readonly sheetIndexes?: number[] | cdk.IResolvable;
        /**
         * `CfnRecipe.RecipeParametersProperty.SheetNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sheetnames
         * @external
         */
        readonly sheetNames?: string[];
        /**
         * `CfnRecipe.RecipeParametersProperty.SourceColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sourcecolumn
         * @external
         */
        readonly sourceColumn?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SourceColumn1`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sourcecolumn1
         * @external
         */
        readonly sourceColumn1?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SourceColumn2`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sourcecolumn2
         * @external
         */
        readonly sourceColumn2?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.SourceColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-sourcecolumns
         * @external
         */
        readonly sourceColumns?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StartColumnIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-startcolumnindex
         * @external
         */
        readonly startColumnIndex?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StartPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-startpattern
         * @external
         */
        readonly startPattern?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StartPosition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-startposition
         * @external
         */
        readonly startPosition?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StartValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-startvalue
         * @external
         */
        readonly startValue?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StemmingMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-stemmingmode
         * @external
         */
        readonly stemmingMode?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StepCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-stepcount
         * @external
         */
        readonly stepCount?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StepIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-stepindex
         * @external
         */
        readonly stepIndex?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.StopWordsMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-stopwordsmode
         * @external
         */
        readonly stopWordsMode?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Strategy`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-strategy
         * @external
         */
        readonly strategy?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TargetColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-targetcolumn
         * @external
         */
        readonly targetColumn?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TargetColumnNames`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-targetcolumnnames
         * @external
         */
        readonly targetColumnNames?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TargetDateFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-targetdateformat
         * @external
         */
        readonly targetDateFormat?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TargetIndex`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-targetindex
         * @external
         */
        readonly targetIndex?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TimeZone`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-timezone
         * @external
         */
        readonly timeZone?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TokenizerPattern`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-tokenizerpattern
         * @external
         */
        readonly tokenizerPattern?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.TrueString`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-truestring
         * @external
         */
        readonly trueString?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.UdfLang`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-udflang
         * @external
         */
        readonly udfLang?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Units`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-units
         * @external
         */
        readonly units?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.UnpivotColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-unpivotcolumn
         * @external
         */
        readonly unpivotColumn?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.UpperBound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-upperbound
         * @external
         */
        readonly upperBound?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.UseNewDataFrame`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-usenewdataframe
         * @external
         */
        readonly useNewDataFrame?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-value
         * @external
         */
        readonly value?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Value1`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-value1
         * @external
         */
        readonly value1?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.Value2`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-value2
         * @external
         */
        readonly value2?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.ValueColumn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-valuecolumn
         * @external
         */
        readonly valueColumn?: string;
        /**
         * `CfnRecipe.RecipeParametersProperty.ViewFrame`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipeparameters.html#cfn-databrew-recipe-recipeparameters-viewframe
         * @external
         */
        readonly viewFrame?: string;
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipestep.html
     * @external
     */
    interface RecipeStepProperty {
        /**
         * `CfnRecipe.RecipeStepProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipestep.html#cfn-databrew-recipe-recipestep-action
         * @external
         */
        readonly action: CfnRecipe.ActionProperty | cdk.IResolvable;
        /**
         * `CfnRecipe.RecipeStepProperty.ConditionExpressions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-recipestep.html#cfn-databrew-recipe-recipestep-conditionexpressions
         * @external
         */
        readonly conditionExpressions?: Array<CfnRecipe.ConditionExpressionProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-s3location.html
     * @external
     */
    interface S3LocationProperty {
        /**
         * `CfnRecipe.S3LocationProperty.Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-s3location.html#cfn-databrew-recipe-s3location-bucket
         * @external
         */
        readonly bucket: string;
        /**
         * `CfnRecipe.S3LocationProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-s3location.html#cfn-databrew-recipe-s3location-key
         * @external
         */
        readonly key?: string;
    }
}
/**
 * A CloudFormation `AWS::DataBrew::Recipe`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-recipe.html
 * @external
 * @cloudformationResource AWS::DataBrew::Recipe
 */
export declare namespace CfnRecipe {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-secondaryinput.html
     * @external
     */
    interface SecondaryInputProperty {
        /**
         * `CfnRecipe.SecondaryInputProperty.DataCatalogInputDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-secondaryinput.html#cfn-databrew-recipe-secondaryinput-datacataloginputdefinition
         * @external
         */
        readonly dataCatalogInputDefinition?: CfnRecipe.DataCatalogInputDefinitionProperty | cdk.IResolvable;
        /**
         * `CfnRecipe.SecondaryInputProperty.S3InputDefinition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-databrew-recipe-secondaryinput.html#cfn-databrew-recipe-secondaryinput-s3inputdefinition
         * @external
         */
        readonly s3InputDefinition?: CfnRecipe.S3LocationProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::DataBrew::Schedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html
 * @external
 */
export interface CfnScheduleProps {
    /**
     * `AWS::DataBrew::Schedule.CronExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-cronexpression
     * @external
     */
    readonly cronExpression: string;
    /**
     * `AWS::DataBrew::Schedule.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::DataBrew::Schedule.JobNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-jobnames
     * @external
     */
    readonly jobNames?: string[];
    /**
     * `AWS::DataBrew::Schedule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::DataBrew::Schedule`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html
 * @external
 * @cloudformationResource AWS::DataBrew::Schedule
 */
export declare class CfnSchedule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::DataBrew::Schedule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSchedule;
    /**
     * `AWS::DataBrew::Schedule.CronExpression`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-cronexpression
     * @external
     */
    cronExpression: string;
    /**
     * `AWS::DataBrew::Schedule.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-name
     * @external
     */
    name: string;
    /**
     * `AWS::DataBrew::Schedule.JobNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-jobnames
     * @external
     */
    jobNames: string[] | undefined;
    /**
     * `AWS::DataBrew::Schedule.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-databrew-schedule.html#cfn-databrew-schedule-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::DataBrew::Schedule`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScheduleProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
