"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cfn = require("@aws-cdk/aws-cloudformation");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const cpactions = require("@aws-cdk/aws-codepipeline-actions");
const s3 = require("@aws-cdk/aws-s3");
const cdk = require("@aws-cdk/core");
const cicd = require("../lib");
const app = new cdk.App();
const stack = new cdk.Stack(app, 'CICD');
const pipeline = new codepipeline.Pipeline(stack, 'CodePipeline', {
    artifactBucket: new s3.Bucket(stack, 'ArtifactBucket', {
        removalPolicy: cdk.RemovalPolicy.DESTROY,
    }),
});
const sourceOutput = new codepipeline.Artifact('Artifact_CICDGitHubF8BA7ADD');
const source = new cpactions.GitHubSourceAction({
    actionName: 'GitHub',
    owner: 'awslabs',
    repo: 'aws-cdk',
    oauthToken: cdk.SecretValue.plainText('DummyToken'),
    trigger: cpactions.GitHubTrigger.POLL,
    output: sourceOutput,
});
pipeline.addStage({
    stageName: 'Source',
    actions: [source],
});
const stage = pipeline.addStage({ stageName: 'Deploy' });
stage.addAction(new cicd.PipelineDeployStackAction({
    stack,
    changeSetName: 'CICD-ChangeSet',
    createChangeSetRunOrder: 10,
    executeChangeSetRunOrder: 999,
    input: sourceOutput,
    adminPermissions: false,
    capabilities: [cfn.CloudFormationCapabilities.NONE],
}));
app.synth();
//# sourceMappingURL=data:application/json;base64,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