/**
 * An interface that represents the location of a specific object in an S3 Bucket.
 *
 * @stability stable
 */
export interface Location {
    /**
     * The name of the S3 Bucket the object is in.
     *
     * @stability stable
     */
    readonly bucketName: string;
    /**
     * The path inside the Bucket where the object is located at.
     *
     * @stability stable
     */
    readonly objectKey: string;
    /**
     * The S3 object version.
     *
     * @stability stable
     */
    readonly objectVersion?: string;
}
