/**
 *  Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as api from '@aws-cdk/aws-apigateway';
import { Construct } from '@aws-cdk/core';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
/**
 * @summary The properties for the ApiGatewayToSqs class.
 */
export interface ApiGatewayToDynamoDBProps {
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly dynamoTableProps?: dynamodb.TableProps;
    /**
     * Optional user-provided props to override the default props for the API Gateway.
     *
     * @default - Default properties are used.
     */
    readonly apiGatewayProps?: api.RestApiProps | any;
    /**
     * Whether to deploy API Gateway Method for Create operation on Dynamodb DB table.
     *
     * @default - false
     */
    readonly allowCreateOperation?: boolean;
    /**
     * API Gateway Request template for Create method, required if allowCreateOperation set to true
     *
     * @default - None
     */
    readonly createRequestTemplate?: string;
    /**
     * Whether to deploy API Gateway Method for Read operation on Dynamodb DB table.
     *
     * @default - true
     */
    readonly allowReadOperation?: boolean;
    /**
     * Whether to deploy API Gateway Method for Update operation on Dynamodb DB table.
     *
     * @default - false
     */
    readonly allowUpdateOperation?: boolean;
    /**
     * API Gateway Request template for Update method, required if allowUpdateOperation set to true
     *
     * @default - None
     */
    readonly updateRequestTemplate?: string;
    /**
     * Whether to deploy API Gateway Method for Delete operation on Dynamodb DB table.
     *
     * @default - false
     */
    readonly allowDeleteOperation?: boolean;
}
/**
 * @summary The ApiGatewayToDynamoDB class.
 */
export declare class ApiGatewayToDynamoDB extends Construct {
    private table;
    private apiGatewayRole;
    private apiGateway;
    /**
     * @summary Constructs a new instance of the ApiGatewayToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToApiGatewayToLambdaProps} props - user provided props for the construct.
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: ApiGatewayToDynamoDBProps);
    private addActiontoPlicy;
    private addMethod;
    /**
     * @summary Returns an instance of the api.RestApi created by the construct.
     * @returns {api.RestApi} Instance of the RestApi created by the construct.
     * @since 0.8.0
     * @access public
     */
    restApi(): api.RestApi;
    /**
     * @summary Retruns an instance of dynamodb.Table created by the construct.
     * @returns {dynamodb.Table} Instance of dynamodb.Table created by the construct
     * @since 0.8.0
     * @access public
     */
    dynamoTable(): dynamodb.Table;
}
