"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AttributeGroup = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const validation_1 = require("./private/validation");
const aws_servicecatalogappregistry_1 = require("aws-cdk-lib/aws-servicecatalogappregistry");
class AttributeGroupBase extends cdk.Resource {
}
/**
 * A Service Catalog AppRegistry Attribute Group.
 */
class AttributeGroup extends AttributeGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_AttributeGroupProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.validateAttributeGroupProps(props);
        const attributeGroup = new aws_servicecatalogappregistry_1.CfnAttributeGroup(this, 'Resource', {
            name: props.attributeGroupName,
            description: props.description,
            attributes: props.attributes,
        });
        this.attributeGroupArn = attributeGroup.attrArn;
        this.attributeGroupId = attributeGroup.attrId;
    }
    /**
     * Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group
     */
    static fromAttributeGroupArn(scope, id, attributeGroupArn) {
        const arn = cdk.Stack.of(scope).splitArn(attributeGroupArn, cdk.ArnFormat.SLASH_RESOURCE_SLASH_RESOURCE_NAME);
        const attributeGroupId = arn.resourceName;
        if (!attributeGroupId) {
            throw new Error('Missing required Attribute Group ID from Attribute Group ARN: ' + attributeGroupArn);
        }
        class Import extends AttributeGroupBase {
            constructor() {
                super(...arguments);
                this.attributeGroupArn = attributeGroupArn;
                this.attributeGroupId = attributeGroupId;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: attributeGroupArn,
        });
    }
    validateAttributeGroupProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group name', 1, 256, props.attributeGroupName);
        validation_1.InputValidator.validateRegex(this.node.path, 'attribute group name', /^[a-zA-Z0-9-_]+$/, props.attributeGroupName);
        validation_1.InputValidator.validateLength(this.node.path, 'attribute group description', 0, 1024, props.description);
    }
}
exports.AttributeGroup = AttributeGroup;
_a = JSII_RTTI_SYMBOL_1;
AttributeGroup[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.AttributeGroup", version: "2.26.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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