"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAccountUnresolved = exports.isRegionUnresolved = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
  * Verifies if application or the visited node is region agnostic.
  *
  * @param applicationRegion Region of the application.
  * @param nodeRegion Region of the visited node.
  */
function isRegionUnresolved(applicationRegion, nodeRegion) {
    return aws_cdk_lib_1.Token.isUnresolved(applicationRegion) || aws_cdk_lib_1.Token.isUnresolved(nodeRegion);
}
exports.isRegionUnresolved = isRegionUnresolved;
/**
  * Verifies if application or the visited node is account agnostic.
  *
  * @param applicationAccount Account of the application.
  * @param nodeAccount Account of the visited node.
  */
function isAccountUnresolved(applicationAccount, nodeAccount) {
    return aws_cdk_lib_1.Token.isUnresolved(applicationAccount) || aws_cdk_lib_1.Token.isUnresolved(nodeAccount);
}
exports.isAccountUnresolved = isAccountUnresolved;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2Q0FBb0M7QUFHcEM7Ozs7O0lBS0k7QUFDSixTQUFnQixrQkFBa0IsQ0FBQyxpQkFBeUIsRUFBRSxVQUFrQjtJQUM5RSxPQUFPLG1CQUFLLENBQUMsWUFBWSxDQUFDLGlCQUFpQixDQUFDLElBQUksbUJBQUssQ0FBQyxZQUFZLENBQUMsVUFBVSxDQUFDLENBQUM7QUFDakYsQ0FBQztBQUZELGdEQUVDO0FBRUQ7Ozs7O0lBS0k7QUFDSixTQUFnQixtQkFBbUIsQ0FBQyxrQkFBMEIsRUFBRSxXQUFtQjtJQUNqRixPQUFPLG1CQUFLLENBQUMsWUFBWSxDQUFDLGtCQUFrQixDQUFDLElBQUksbUJBQUssQ0FBQyxZQUFZLENBQUMsV0FBVyxDQUFDLENBQUM7QUFDbkYsQ0FBQztBQUZELGtEQUVDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgVG9rZW4gfSBmcm9tICdhd3MtY2RrLWxpYic7XG5cblxuLyoqXG4gICogVmVyaWZpZXMgaWYgYXBwbGljYXRpb24gb3IgdGhlIHZpc2l0ZWQgbm9kZSBpcyByZWdpb24gYWdub3N0aWMuXG4gICpcbiAgKiBAcGFyYW0gYXBwbGljYXRpb25SZWdpb24gUmVnaW9uIG9mIHRoZSBhcHBsaWNhdGlvbi5cbiAgKiBAcGFyYW0gbm9kZVJlZ2lvbiBSZWdpb24gb2YgdGhlIHZpc2l0ZWQgbm9kZS5cbiAgKi9cbmV4cG9ydCBmdW5jdGlvbiBpc1JlZ2lvblVucmVzb2x2ZWQoYXBwbGljYXRpb25SZWdpb246IHN0cmluZywgbm9kZVJlZ2lvbjogc3RyaW5nKTogYm9vbGVhbiB7XG4gIHJldHVybiBUb2tlbi5pc1VucmVzb2x2ZWQoYXBwbGljYXRpb25SZWdpb24pIHx8IFRva2VuLmlzVW5yZXNvbHZlZChub2RlUmVnaW9uKTtcbn1cblxuLyoqXG4gICogVmVyaWZpZXMgaWYgYXBwbGljYXRpb24gb3IgdGhlIHZpc2l0ZWQgbm9kZSBpcyBhY2NvdW50IGFnbm9zdGljLlxuICAqXG4gICogQHBhcmFtIGFwcGxpY2F0aW9uQWNjb3VudCBBY2NvdW50IG9mIHRoZSBhcHBsaWNhdGlvbi5cbiAgKiBAcGFyYW0gbm9kZUFjY291bnQgQWNjb3VudCBvZiB0aGUgdmlzaXRlZCBub2RlLlxuICAqL1xuZXhwb3J0IGZ1bmN0aW9uIGlzQWNjb3VudFVucmVzb2x2ZWQoYXBwbGljYXRpb25BY2NvdW50OiBzdHJpbmcsIG5vZGVBY2NvdW50OiBzdHJpbmcpOiBib29sZWFuIHtcbiAgcmV0dXJuIFRva2VuLmlzVW5yZXNvbHZlZChhcHBsaWNhdGlvbkFjY291bnQpIHx8IFRva2VuLmlzVW5yZXNvbHZlZChub2RlQWNjb3VudCk7XG59Il19