"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const stepfunctions = require("../lib");
describe('Condition Variables', () => {
    test('Condition variables must start with $. or $[', () => {
        expect(() => stepfunctions.Condition.stringEquals('a', 'b')).toThrow();
    }),
        test('Condition variables can start with $.', () => {
            expect(() => stepfunctions.Condition.stringEquals('$.a', 'b')).not.toThrow();
        }),
        test('Condition variables can start with $[', () => {
            expect(() => stepfunctions.Condition.stringEquals('$[0]', 'a')).not.toThrow();
        }),
        test('NotConditon must render properly', () => {
            assertRendersTo(stepfunctions.Condition.not(stepfunctions.Condition.stringEquals('$.a', 'b')), { Not: { Variable: '$.a', StringEquals: 'b' } });
        }),
        test('CompoundCondition must render properly', () => {
            assertRendersTo(stepfunctions.Condition.and(stepfunctions.Condition.booleanEquals('$.a', true), stepfunctions.Condition.numberGreaterThan('$.b', 3)), {
                And: [
                    { Variable: '$.a', BooleanEquals: true },
                    { Variable: '$.b', NumericGreaterThan: 3 },
                ],
            });
        }),
        test('Exercise a number of other conditions', () => {
            const cases = [
                [stepfunctions.Condition.stringLessThan('$.a', 'foo'), { Variable: '$.a', StringLessThan: 'foo' }],
                [stepfunctions.Condition.stringLessThanEquals('$.a', 'foo'), { Variable: '$.a', StringLessThanEquals: 'foo' }],
                [stepfunctions.Condition.stringGreaterThan('$.a', 'foo'), { Variable: '$.a', StringGreaterThan: 'foo' }],
                [stepfunctions.Condition.stringGreaterThanEquals('$.a', 'foo'), { Variable: '$.a', StringGreaterThanEquals: 'foo' }],
                [stepfunctions.Condition.numberEquals('$.a', 5), { Variable: '$.a', NumericEquals: 5 }],
            ];
            for (const [cond, expected] of cases) {
                assertRendersTo(cond, expected);
            }
        });
});
function assertRendersTo(cond, expected) {
    expect(cond.renderCondition()).toStrictEqual(expected);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uZGl0aW9uLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjb25kaXRpb24udGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGdDQUE4QjtBQUM5Qix3Q0FBd0M7QUFFeEMsUUFBUSxDQUFDLHFCQUFxQixFQUFFLEdBQUcsRUFBRTtJQUNuQyxJQUFJLENBQUMsOENBQThDLEVBQUUsR0FBRyxFQUFFO1FBQ3hELE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxHQUFHLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxPQUFPLEVBQUUsQ0FBQztJQUN6RSxDQUFDLENBQUM7UUFDRixJQUFJLENBQUMsdUNBQXVDLEVBQUUsR0FBRyxFQUFFO1lBQ2pELE1BQU0sQ0FBQyxHQUFHLEVBQUUsQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLFlBQVksQ0FBQyxLQUFLLEVBQUUsR0FBRyxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsT0FBTyxFQUFFLENBQUM7UUFDL0UsQ0FBQyxDQUFDO1FBQ0YsSUFBSSxDQUFDLHVDQUF1QyxFQUFFLEdBQUcsRUFBRTtZQUNqRCxNQUFNLENBQUMsR0FBRyxFQUFFLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsTUFBTSxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsR0FBRyxDQUFDLE9BQU8sRUFBRSxDQUFDO1FBQ2hGLENBQUMsQ0FBQztRQUNGLElBQUksQ0FBQyxrQ0FBa0MsRUFBRSxHQUFHLEVBQUU7WUFDNUMsZUFBZSxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsWUFBWSxDQUFDLEtBQUssRUFBRSxHQUFHLENBQUMsQ0FBQyxFQUFFLEVBQUUsR0FBRyxFQUFFLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxZQUFZLEVBQUUsR0FBRyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBQ2xKLENBQUMsQ0FBQztRQUNGLElBQUksQ0FBQyx3Q0FBd0MsRUFBRSxHQUFHLEVBQUU7WUFDbEQsZUFBZSxDQUNiLGFBQWEsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsYUFBYSxDQUFDLEtBQUssRUFBRSxJQUFJLENBQUMsRUFBRSxhQUFhLENBQUMsU0FBUyxDQUFDLGlCQUFpQixDQUFDLEtBQUssRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUNwSTtnQkFDRSxHQUFHLEVBQUU7b0JBQ0gsRUFBRSxRQUFRLEVBQUUsS0FBSyxFQUFFLGFBQWEsRUFBRSxJQUFJLEVBQUU7b0JBQ3hDLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxrQkFBa0IsRUFBRSxDQUFDLEVBQUU7aUJBQzNDO2FBQ0YsQ0FDRixDQUFDO1FBQ0osQ0FBQyxDQUFDO1FBQ0YsSUFBSSxDQUFDLHVDQUF1QyxFQUFFLEdBQUcsRUFBRTtZQUNqRCxNQUFNLEtBQUssR0FBNkM7Z0JBQ3RELENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxjQUFjLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxjQUFjLEVBQUUsS0FBSyxFQUFFLENBQUM7Z0JBQ2xHLENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxvQkFBb0IsQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLEVBQUUsRUFBRSxRQUFRLEVBQUUsS0FBSyxFQUFFLG9CQUFvQixFQUFFLEtBQUssRUFBRSxDQUFDO2dCQUM5RyxDQUFDLGFBQWEsQ0FBQyxTQUFTLENBQUMsaUJBQWlCLENBQUMsS0FBSyxFQUFFLEtBQUssQ0FBQyxFQUFFLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxpQkFBaUIsRUFBRSxLQUFLLEVBQUUsQ0FBQztnQkFDeEcsQ0FBQyxhQUFhLENBQUMsU0FBUyxDQUFDLHVCQUF1QixDQUFDLEtBQUssRUFBRSxLQUFLLENBQUMsRUFBRSxFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsdUJBQXVCLEVBQUUsS0FBSyxFQUFFLENBQUM7Z0JBQ3BILENBQUMsYUFBYSxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxFQUFFLEVBQUUsUUFBUSxFQUFFLEtBQUssRUFBRSxhQUFhLEVBQUUsQ0FBQyxFQUFFLENBQUM7YUFDeEYsQ0FBQztZQUVGLEtBQUssTUFBTSxDQUFDLElBQUksRUFBRSxRQUFRLENBQUMsSUFBSSxLQUFLLEVBQUU7Z0JBQ3BDLGVBQWUsQ0FBQyxJQUFJLEVBQUUsUUFBUSxDQUFDLENBQUM7YUFDakM7UUFDSCxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDO0FBRUgsU0FBUyxlQUFlLENBQUMsSUFBNkIsRUFBRSxRQUFhO0lBQ25FLE1BQU0sQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLENBQUMsQ0FBQyxhQUFhLENBQUMsUUFBUSxDQUFDLENBQUM7QUFDekQsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuaW1wb3J0ICogYXMgc3RlcGZ1bmN0aW9ucyBmcm9tICcuLi9saWInO1xuXG5kZXNjcmliZSgnQ29uZGl0aW9uIFZhcmlhYmxlcycsICgpID0+IHtcbiAgdGVzdCgnQ29uZGl0aW9uIHZhcmlhYmxlcyBtdXN0IHN0YXJ0IHdpdGggJC4gb3IgJFsnLCAoKSA9PiB7XG4gICAgZXhwZWN0KCgpID0+IHN0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLnN0cmluZ0VxdWFscygnYScsICdiJykpLnRvVGhyb3coKTtcbiAgfSksXG4gIHRlc3QoJ0NvbmRpdGlvbiB2YXJpYWJsZXMgY2FuIHN0YXJ0IHdpdGggJC4nLCAoKSA9PiB7XG4gICAgZXhwZWN0KCgpID0+IHN0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLnN0cmluZ0VxdWFscygnJC5hJywgJ2InKSkubm90LnRvVGhyb3coKTtcbiAgfSksXG4gIHRlc3QoJ0NvbmRpdGlvbiB2YXJpYWJsZXMgY2FuIHN0YXJ0IHdpdGggJFsnLCAoKSA9PiB7XG4gICAgZXhwZWN0KCgpID0+IHN0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLnN0cmluZ0VxdWFscygnJFswXScsICdhJykpLm5vdC50b1Rocm93KCk7XG4gIH0pLFxuICB0ZXN0KCdOb3RDb25kaXRvbiBtdXN0IHJlbmRlciBwcm9wZXJseScsICgpID0+IHtcbiAgICBhc3NlcnRSZW5kZXJzVG8oc3RlcGZ1bmN0aW9ucy5Db25kaXRpb24ubm90KHN0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLnN0cmluZ0VxdWFscygnJC5hJywgJ2InKSksIHsgTm90OiB7IFZhcmlhYmxlOiAnJC5hJywgU3RyaW5nRXF1YWxzOiAnYicgfSB9KTtcbiAgfSksXG4gIHRlc3QoJ0NvbXBvdW5kQ29uZGl0aW9uIG11c3QgcmVuZGVyIHByb3Blcmx5JywgKCkgPT4ge1xuICAgIGFzc2VydFJlbmRlcnNUbyhcbiAgICAgIHN0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLmFuZChzdGVwZnVuY3Rpb25zLkNvbmRpdGlvbi5ib29sZWFuRXF1YWxzKCckLmEnLCB0cnVlKSwgc3RlcGZ1bmN0aW9ucy5Db25kaXRpb24ubnVtYmVyR3JlYXRlclRoYW4oJyQuYicsIDMpKSxcbiAgICAgIHtcbiAgICAgICAgQW5kOiBbXG4gICAgICAgICAgeyBWYXJpYWJsZTogJyQuYScsIEJvb2xlYW5FcXVhbHM6IHRydWUgfSxcbiAgICAgICAgICB7IFZhcmlhYmxlOiAnJC5iJywgTnVtZXJpY0dyZWF0ZXJUaGFuOiAzIH0sXG4gICAgICAgIF0sXG4gICAgICB9XG4gICAgKTtcbiAgfSksXG4gIHRlc3QoJ0V4ZXJjaXNlIGEgbnVtYmVyIG9mIG90aGVyIGNvbmRpdGlvbnMnLCAoKSA9PiB7XG4gICAgY29uc3QgY2FzZXM6IEFycmF5PFtzdGVwZnVuY3Rpb25zLkNvbmRpdGlvbiwgb2JqZWN0XT4gPSBbXG4gICAgICBbc3RlcGZ1bmN0aW9ucy5Db25kaXRpb24uc3RyaW5nTGVzc1RoYW4oJyQuYScsICdmb28nKSwgeyBWYXJpYWJsZTogJyQuYScsIFN0cmluZ0xlc3NUaGFuOiAnZm9vJyB9XSxcbiAgICAgIFtzdGVwZnVuY3Rpb25zLkNvbmRpdGlvbi5zdHJpbmdMZXNzVGhhbkVxdWFscygnJC5hJywgJ2ZvbycpLCB7IFZhcmlhYmxlOiAnJC5hJywgU3RyaW5nTGVzc1RoYW5FcXVhbHM6ICdmb28nIH1dLFxuICAgICAgW3N0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLnN0cmluZ0dyZWF0ZXJUaGFuKCckLmEnLCAnZm9vJyksIHsgVmFyaWFibGU6ICckLmEnLCBTdHJpbmdHcmVhdGVyVGhhbjogJ2ZvbycgfV0sXG4gICAgICBbc3RlcGZ1bmN0aW9ucy5Db25kaXRpb24uc3RyaW5nR3JlYXRlclRoYW5FcXVhbHMoJyQuYScsICdmb28nKSwgeyBWYXJpYWJsZTogJyQuYScsIFN0cmluZ0dyZWF0ZXJUaGFuRXF1YWxzOiAnZm9vJyB9XSxcbiAgICAgIFtzdGVwZnVuY3Rpb25zLkNvbmRpdGlvbi5udW1iZXJFcXVhbHMoJyQuYScsIDUpLCB7IFZhcmlhYmxlOiAnJC5hJywgTnVtZXJpY0VxdWFsczogNSB9XSxcbiAgICBdO1xuXG4gICAgZm9yIChjb25zdCBbY29uZCwgZXhwZWN0ZWRdIG9mIGNhc2VzKSB7XG4gICAgICBhc3NlcnRSZW5kZXJzVG8oY29uZCwgZXhwZWN0ZWQpO1xuICAgIH1cbiAgfSk7XG59KTtcblxuZnVuY3Rpb24gYXNzZXJ0UmVuZGVyc1RvKGNvbmQ6IHN0ZXBmdW5jdGlvbnMuQ29uZGl0aW9uLCBleHBlY3RlZDogYW55KSB7XG4gIGV4cGVjdChjb25kLnJlbmRlckNvbmRpdGlvbigpKS50b1N0cmljdEVxdWFsKGV4cGVjdGVkKTtcbn1cbiJdfQ==