"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
describe('Activity', () => {
    test('instantiate Activity', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        new stepfunctions.Activity(stack, 'Activity');
        // THEN
        expect(stack).toHaveResource('AWS::StepFunctions::Activity', {
            Name: 'Activity'
        });
    });
    test('Activity exposes metrics', () => {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const activity = new stepfunctions.Activity(stack, 'Activity');
        // THEN
        const sharedMetric = {
            period: cdk.Duration.minutes(5),
            namespace: 'AWS/States',
            dimensions: { ActivityArn: { Ref: 'Activity04690B0A' } },
        };
        expect((stack.resolve(activity.metricRunTime()))).toEqual({
            ...sharedMetric,
            metricName: 'ActivityRunTime',
            statistic: 'Average'
        });
        expect(stack.resolve(activity.metricFailed())).toEqual({
            ...sharedMetric,
            metricName: 'ActivitiesFailed',
            statistic: 'Sum'
        });
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aXZpdHkudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFjdGl2aXR5LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxnQ0FBOEI7QUFDOUIscUNBQXFDO0FBQ3JDLHdDQUF3QztBQUV4QyxRQUFRLENBQUMsVUFBVSxFQUFFLEdBQUcsRUFBRTtJQUN4QixJQUFJLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxFQUFFO1FBQ2hDLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsSUFBSSxhQUFhLENBQUMsUUFBUSxDQUFDLEtBQUssRUFBRSxVQUFVLENBQUMsQ0FBQztRQUU5QyxPQUFPO1FBQ1AsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDLGNBQWMsQ0FBQyw4QkFBOEIsRUFBRTtZQUMzRCxJQUFJLEVBQUUsVUFBVTtTQUNqQixDQUFDLENBQUM7SUFDTCxDQUFDLENBQUMsQ0FBQztJQUVILElBQUksQ0FBQywwQkFBMEIsRUFBRSxHQUFHLEVBQUU7UUFDcEMsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLE9BQU87UUFDUCxNQUFNLFFBQVEsR0FBRyxJQUFJLGFBQWEsQ0FBQyxRQUFRLENBQUMsS0FBSyxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBRS9ELE9BQU87UUFDUCxNQUFNLFlBQVksR0FBRztZQUNuQixNQUFNLEVBQUUsR0FBRyxDQUFDLFFBQVEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO1lBQy9CLFNBQVMsRUFBRSxZQUFZO1lBQ3ZCLFVBQVUsRUFBRSxFQUFFLFdBQVcsRUFBRSxFQUFFLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFDO1NBQ3hELENBQUM7UUFDRixNQUFNLENBQUMsQ0FBQyxLQUFLLENBQUMsT0FBTyxDQUFDLFFBQVEsQ0FBQyxhQUFhLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUM7WUFDeEQsR0FBRyxZQUFZO1lBQ2YsVUFBVSxFQUFFLGlCQUFpQjtZQUM3QixTQUFTLEVBQUUsU0FBUztTQUNyQixDQUFDLENBQUM7UUFFSCxNQUFNLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxRQUFRLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQztZQUNyRCxHQUFHLFlBQVk7WUFDZixVQUFVLEVBQUUsa0JBQWtCO1lBQzlCLFNBQVMsRUFBRSxLQUFLO1NBQ2pCLENBQUMsQ0FBQztJQUNMLENBQUMsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyxDQUFDLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgJ0Bhd3MtY2RrL2Fzc2VydC9qZXN0JztcbmltcG9ydCAqIGFzIGNkayBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCAqIGFzIHN0ZXBmdW5jdGlvbnMgZnJvbSAnLi4vbGliJztcblxuZGVzY3JpYmUoJ0FjdGl2aXR5JywgKCkgPT4ge1xuICB0ZXN0KCdpbnN0YW50aWF0ZSBBY3Rpdml0eScsICgpID0+IHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuXG4gICAgLy8gV0hFTlxuICAgIG5ldyBzdGVwZnVuY3Rpb25zLkFjdGl2aXR5KHN0YWNrLCAnQWN0aXZpdHknKTtcblxuICAgIC8vIFRIRU5cbiAgICBleHBlY3Qoc3RhY2spLnRvSGF2ZVJlc291cmNlKCdBV1M6OlN0ZXBGdW5jdGlvbnM6OkFjdGl2aXR5Jywge1xuICAgICAgTmFtZTogJ0FjdGl2aXR5J1xuICAgIH0pO1xuICB9KTtcblxuICB0ZXN0KCdBY3Rpdml0eSBleHBvc2VzIG1ldHJpY3MnLCAoKSA9PiB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgIC8vIFdIRU5cbiAgICBjb25zdCBhY3Rpdml0eSA9IG5ldyBzdGVwZnVuY3Rpb25zLkFjdGl2aXR5KHN0YWNrLCAnQWN0aXZpdHknKTtcblxuICAgIC8vIFRIRU5cbiAgICBjb25zdCBzaGFyZWRNZXRyaWMgPSB7XG4gICAgICBwZXJpb2Q6IGNkay5EdXJhdGlvbi5taW51dGVzKDUpLFxuICAgICAgbmFtZXNwYWNlOiAnQVdTL1N0YXRlcycsXG4gICAgICBkaW1lbnNpb25zOiB7IEFjdGl2aXR5QXJuOiB7IFJlZjogJ0FjdGl2aXR5MDQ2OTBCMEEnIH19LFxuICAgIH07XG4gICAgZXhwZWN0KChzdGFjay5yZXNvbHZlKGFjdGl2aXR5Lm1ldHJpY1J1blRpbWUoKSkpKS50b0VxdWFsKHtcbiAgICAgIC4uLnNoYXJlZE1ldHJpYyxcbiAgICAgIG1ldHJpY05hbWU6ICdBY3Rpdml0eVJ1blRpbWUnLFxuICAgICAgc3RhdGlzdGljOiAnQXZlcmFnZSdcbiAgICB9KTtcblxuICAgIGV4cGVjdChzdGFjay5yZXNvbHZlKGFjdGl2aXR5Lm1ldHJpY0ZhaWxlZCgpKSkudG9FcXVhbCh7XG4gICAgICAuLi5zaGFyZWRNZXRyaWMsXG4gICAgICBtZXRyaWNOYW1lOiAnQWN0aXZpdGllc0ZhaWxlZCcsXG4gICAgICBzdGF0aXN0aWM6ICdTdW0nXG4gICAgfSk7XG4gIH0pO1xufSk7XG4iXX0=