# Generated by Django 3.2.8 on 2021-10-19 01:47

from django.core.exceptions import ObjectDoesNotExist
from django.db import migrations


def modify_aa_team_token_add_page_ignore_paths(apps, schema_editor):
    # Add the /account/activate path to ignore

    AnalyticsPath = apps.get_model('analytics', 'AnalyticsPath')
    account_activate = AnalyticsPath.objects.create(ignore_path=r"^\/account\/activate\/.*")

    Tokens = apps.get_model('analytics', 'AnalyticsTokens')
    token = Tokens.objects.get(token="UA-186249766-2")
    token.ignore_paths.add(account_activate)


def undo_modify_aa_team_token_add_page_ignore_paths(apps, schema_editor):
    #
    AnalyticsPath = apps.get_model('analytics', 'AnalyticsPath')
    Tokens = apps.get_model('analytics', 'AnalyticsTokens')

    token = Tokens.objects.get(token="UA-186249766-2")

    try:
        account_activate = AnalyticsPath.objects.get(ignore_path=r"^\/account\/activate\/.*", analyticstokens=token)
        account_activate.delete()
    except ObjectDoesNotExist:
        # Its fine if it doesnt exist, we just dont want them building up when re-migrating
        pass

class Migration(migrations.Migration):

    dependencies = [
        ('analytics', '0005_alter_analyticspath_ignore_path'),
    ]

    operations = [
        migrations.RunPython(modify_aa_team_token_add_page_ignore_paths, undo_modify_aa_team_token_add_page_ignore_paths)
    ]
