# Generated by Django 3.1.4 on 2020-12-30 08:53

from django.db import migrations


def add_aa_team_token(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    Tokens = apps.get_model('analytics', 'AnalyticsTokens')
    token = Tokens()
    token.type = 'GA-U'
    token.token = 'UA-186249766-2'
    token.send_page_views = True
    token.send_celery_tasks = True
    token.send_stats = True
    token.name = 'AA Team Public Google Analytics (Universal)'
    token.save()


def remove_aa_team_token(apps, schema_editor):
    # Have to define some code to remove this identifier
    # In case of migration rollback?
    Tokens = apps.get_model('analytics', 'AnalyticsTokens')
    token = Tokens.objects.filter(token="UA-186249766-2").delete()


class Migration(migrations.Migration):

    dependencies = [
        ('analytics', '0001_initial'),
        ]

    operations = [migrations.RunPython(add_aa_team_token, remove_aa_team_token)
                    ]
