"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StateMachineFragment = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chain_1 = require("./chain");
const parallel_1 = require("./states/parallel");
const state_1 = require("./states/state");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * Base class for reusable state machine fragments
 */
class StateMachineFragment extends core_1.Construct {
    get id() {
        return this.node.id;
    }
    /**
     * Prefix the IDs of all states in this state machine fragment
     *
     * Use this to avoid multiple copies of the state machine all having the
     * same state IDs.
     *
     * @param prefix The prefix to add. Will use construct ID by default.
     */
    prefixStates(prefix) {
        state_1.State.prefixStates(this, prefix || `${this.id}: `);
        return this;
    }
    /**
     * Wrap all states in this state machine fragment up into a single state.
     *
     * This can be used to add retry or error handling onto this state
     * machine fragment.
     *
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     */
    toSingleState(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_SingleStateOptions(options);
        const stateId = options.stateId || this.id;
        this.prefixStates(options.prefixStates || `${stateId}: `);
        return new parallel_1.Parallel(this, stateId, options).branch(this);
    }
    /**
     * Continue normal execution with the given state
     */
    next(next) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        return chain_1.Chain.start(this).next(next);
    }
}
exports.StateMachineFragment = StateMachineFragment;
_a = JSII_RTTI_SYMBOL_1;
StateMachineFragment[_a] = { fqn: "@aws-cdk/aws-stepfunctions.StateMachineFragment", version: "1.147.0" };
//# sourceMappingURL=data:application/json;base64,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