import * as cdk from 'aws-cdk-lib';
import { IAttributeGroup } from './attribute-group';
import { Construct } from 'constructs';
/**
 * (experimental) A Service Catalog AppRegistry Application.
 *
 * @experimental
 */
export interface IApplication extends cdk.IResource {
    /**
     * (experimental) The ARN of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly applicationArn: string;
    /**
     * (experimental) The ID of the application.
     *
     * @experimental
     * @attribute true
     */
    readonly applicationId: string;
    /**
     * (experimental) Associate thisapplication with an attribute group.
     *
     * @param attributeGroup AppRegistry attribute group.
     * @experimental
     */
    associateAttributeGroup(attributeGroup: IAttributeGroup): void;
    /**
     * (experimental) Associate this application with a CloudFormation stack.
     *
     * @param stack a CFN stack.
     * @experimental
     */
    associateStack(stack: cdk.Stack): void;
}
/**
 * (experimental) Properties for a Service Catalog AppRegistry Application.
 *
 * @experimental
 */
export interface ApplicationProps {
    /**
     * (experimental) Enforces a particular physical application name.
     *
     * @experimental
     */
    readonly applicationName: string;
    /**
     * (experimental) Description for application.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
}
declare abstract class ApplicationBase extends cdk.Resource implements IApplication {
    abstract readonly applicationArn: string;
    abstract readonly applicationId: string;
    private readonly associatedAttributeGroups;
    private readonly associatedResources;
    /**
     * (experimental) Associate an attribute group with application If the attribute group is already associated, it will ignore duplicate request.
     *
     * @experimental
     */
    associateAttributeGroup(attributeGroup: IAttributeGroup): void;
    /**
     * (experimental) Associate a stack with the application If the resource is already associated, it will ignore duplicate request.
     *
     * A stack can only be associated with one application.
     *
     * @experimental
     */
    associateStack(stack: cdk.Stack): void;
    /**
     * Create a unique id
     */
    protected abstract generateUniqueHash(resourceAddress: string): string;
}
/**
 * (experimental) A Service Catalog AppRegistry Application.
 *
 * @experimental
 */
export declare class Application extends ApplicationBase {
    /**
     * (experimental) Imports an Application construct that represents an external application.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param applicationArn the Amazon Resource Name of the existing AppRegistry Application.
     * @experimental
     */
    static fromApplicationArn(scope: Construct, id: string, applicationArn: string): IApplication;
    /**
     * (experimental) The ARN of the application.
     *
     * @experimental
     */
    readonly applicationArn: string;
    /**
     * (experimental) The ID of the application.
     *
     * @experimental
     */
    readonly applicationId: string;
    private readonly nodeAddress;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ApplicationProps);
    /**
     * (experimental) Create a unique id.
     *
     * @experimental
     */
    protected generateUniqueHash(resourceAddress: string): string;
    private validateApplicationProps;
}
export {};
