"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename));
// Definitions
const props = {
    kinesisAnalyticsProps: {
        inputs: [{
                inputSchema: {
                    recordColumns: [{
                            name: 'ticker_symbol',
                            sqlType: 'VARCHAR(4)',
                            mapping: '$.ticker_symbol'
                        }, {
                            name: 'sector',
                            sqlType: 'VARCHAR(16)',
                            mapping: '$.sector'
                        }, {
                            name: 'change',
                            sqlType: 'REAL',
                            mapping: '$.change'
                        }, {
                            name: 'price',
                            sqlType: 'REAL',
                            mapping: '$.price'
                        }],
                    recordFormat: {
                        recordFormatType: 'JSON'
                    },
                    recordEncoding: 'UTF-8'
                },
                namePrefix: 'SOURCE_SQL_STREAM'
            }]
    },
    bucketProps: {
        removalPolicy: core_1.RemovalPolicy.DESTROY,
    }
};
new lib_1.KinesisFirehoseToAnalyticsAndS3(stack, 'test-firehose-s3-and-analytics-stack', props);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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