# coding=utf-8
import re
import platform

'''
 :SystemInfo:    系统操作类
 :author          bony
 :@version         V1.1
 :@Date            2017年05月
'''

# from Core.Utils.adb_interface import AdbInterface

# adb_interface = AdbInterface()

# 判断系统类型，windows使用findstr，linux使用grep
system_info = platform.system()
if system_info is "Windows":
    find_util = "findstr"
else:
    find_util = "grep"


class SystemInfo(object):
    device = None

    def __init__(self, device=None):
        self.device = device

    def getCpukinds(self):
        return self.device.adb_command("adb shell getprop ro.product.cpu.abi")

    def getDeviceState(self):
        """
        获取设备状态： offline | bootloader | device
         usage: getDeviceState()
        """
        return self.device.adb_command("adb get-state").read_close().split("\n")[0]

    def getDeviceID(self):
        """
        获取设备id号，return serialNo
         usage: getDeviceID()
        """
        return self.device.adb_command("adb get-serialno").read_close().split("\n")[0]

    def getDeviceIDlist(self):
        """
        获取设备id号，return list(serialNo)
         usage: getDeviceIDlist()
        """
        l = []
        tmp = []
        l = self.device.adb_command("adb devices").read_close().split("\r\n")
        del l[0]
        for x in l:
            if x != "":
                tmp.append(x.split("\t")[0].strip('\''))
        return tmp

    def getAppList(self):
        """
        获取设备中安装的应用包名列表
         usage: getAppList()
        """
        app = []
        for packages in self.device.adb_command("adb shell pm list packages").read_close().split():
            app.append(packages.split(":")[1])

        return app

    def getSystemAppList(self):
        """
        获取设备中安装的系统应用包名列表
         usage: getSystemAppList()
        """
        sysApp = []
        for packages in self.device.adb_command("adb shell pm list packages -s").read_close().split():
            sysApp.append(packages.split(":")[1])

        return sysApp

    def getThirdAppList(self):
        """
        获取设备中安装的第三方应用包名列表
         usage: getThirdAppList()
        """
        thirdApp = []
        for packages in self.device.adb_command("adb shell pm list packages -3").read_close().split():
            thirdApp.append(packages.split(":")[1])

        return thirdApp

    def getMatchingAppList(self, keyword):
        """
        模糊查询与keyword匹配的应用包名列表
         args:
        - keyword -: 关键字
        usage: getMatchingAppList("qq")
        """
        matApp = []
        for packages in self.device.adb_command("adb shell pm list packages " + keyword).read_close().split():
            matApp.append(packages.split(":")[1])
        return matApp

    def getAppAddressFromPname(self, packagename):
        """
        根据包名查询应用地址
        args:
        - packagename -: 包名
        usage: getAppAddressFromPname("com.android.test")
        """
        address = self.device.adb_command("adb shell pm list packages -f |" + find_util + " " + packagename).read_close()
        return address.split(":")[1].split("=")[0]

    def getAppAddressFromKeyList(self, key):
        """
        根据关键字查找应用地址
        args:
        - key -: 关键字
        usage: getAppAddressFromKeyList("android")
        """
        l = []
        tmp = []
        l = self.device.adb_command("adb shell pm list packages -f |" + find_util + " " + key).read_close().split("\n")
        for x in l:
            if x != "":
                tmp.append(x.split(":")[1].split("=")[0])
        return tmp

    def getAppAddressList(self):
        """
        获取安装应用地址
        usage: getAppAddressList()
        """
        l = []
        tmp = []
        l = self.device.adb_command("adb shell pm list packages -f").read_close().split("\n")
        for x in l:
            if x != "":
                tmp.append(x.split(":")[1].split("=")[0])
        return tmp

    def getAppNo(self):
        """
        获取应用数量
        usage: getAppNo()
        """
        return len(self.getAppList())

    def get_sys_appno(self):
        """
        获取系统应用数量
        usage: get_sys_appNo()
        """
        return len(self.getSystemAppList())

    def get_third_appno(self):
        """
        获取第三方应用数量
        usage: getThirdAppNo()
        """
        return len(self.getThirdAppList())

    def get_sdk_version(self):
        """
        得到sdk版本号
        usage: getSdkVersion()
        """
        return self.device.adb_command("adb shell getprop ro.build.version.sdk").read_close().split("\r\n")[0]

    def get_cur_handle(self):
        """
        得到当前的handle
        usage: getCurHandle()
        """
        fname = []
        l = self.device.adb_command("adb shell dumpsys SurfaceFlinger").read_close().split("\r\n")
        n = 0
        z = 0
        for x in l:
            n += 1
            if "----------+-" in x:
                fname = l[n - 2].split("|")
                break
        for y in fname:
            z += 1
            if "handle" in y:
                handle = l[n].split("|")
                return handle[z - 1]

    def get_screen_resolution(self):
        """
        获取设备屏幕分辨率，return (width, high)
        usage: getScreenResolution()
        """
        if int(self.get_sdk_version()) < 14:  # 如果版本低于4。0，返回一个320,480
            return 320, 480
        pattern = re.compile(r"\d+")
        try:
            out = self.device.adb_command("adb shell dumpsys display | " + find_util + " PhysicalDisplayInfo").read_close()
            display = pattern.findall(out)
            if len(display) < 1:
                raise Exception('Unable to get PhysicalDisplayInfo' + str(out))
            else:
                return int(display[0]), int(display[1])
        except Exception as e:
            out = self.device.adb_command("adb shell wm size").read_close()
            display = pattern.findall(out)
            if len(display) < 1:
                raise Exception('Unable to get PhysicalDisplayInfo' + str(out))
            else:
                return int(display[0]), int(display[1])
