# Annotell Input API Client

Python 3 library providing access to Annotell Input API

To install with pip run `pip install annotell-input-api`

# Documentation & Getting Started Guide

Documentation about how to use the library can found [here](https://annotell.github.io/annotell-python/)
# Changelog

All notable changes to this project will be documented in this file.

## [1.1.1] - 2021-11-11
### Changed
- Fixed import statement to work with python < 3.9

## [1.1.0] - 2021-11-03
### Added
- Two new methods has been added for downloading annotations: `client.annotation.get_annotation` and `client.annotation.get_project_annotations`. These two methods will serve annotations
in the OpenLABEL format. With this change the previous method for fetching annotations,
 `client.annotation.get_annotations` has become deprecated.

- Stricter typing for the calibrations, specifically the camera calibrations. Each of the supported camera calibration models now have their own class in `annotell.input_api.model.calibration.camera`. Documentation regarding use can be found here: [Documentation](https://annotell.github.io/annotell-python/docs/input-api/calibration)
- Field of View support for camera calibrations
- New Parameter Xi for Fisheye camera calibration model

### Changed
- Two constructor arguments in `InputApiClient` and `FileResourceClient` have been renamed from `max_upload_retry_attemps`, `max_upload_retry_wait_time`
to `max_retry_attempts`, `max_retry_wait_time` respectively.

- The old camera calibration class will be deprecated in favour of the new classes

## [1.0.8] - 2021-09-07
### Added
- A new method has been added, `get_inputs_with_uuids`, which can fetch inputs using only the `input_uuid`.
- `annoutil` has a new flag when fetching inputs, `annoutil inputs --uuids <comma_separated_uuids>`.
- `lidars` and `lidars_sequence` inputs now available through the client.
- A new method has been added, `add_annotation_type`, which adds additional annotation types to be performed for an input.

### Changed
- `client.calibration.get_calibration()` now properly deserializes calibration into `SensorCalibrationEntry` instead of keeping it as a dict.

## [1.0.7] - 2021-06-11
### Added
- `created` timestamp when querying `get_inputs`
- Method `get_annotation_types`

### Changed
- `input_list_id` replaced with `annotation_types` for all createable resources (`Cameras`, `CamerasSeq`, `LidarsAndCameras`, `LidarsAndCamerasSeq`).

## [1.0.6] - 2021-05-28
### Added
- `calibration_id` now available for created inputs via the `client.input.get_inputs` method.
- It is now possible to create your project batches on your own using the
  `client.project.create_batch` method. Please contact Annotell's Professional Services
  before using. More information available in the [documentation](https://annotell.github.io/annotell-python/).

## [1.0.5] - 2021-05-06
### Changed
- Changed the height/width in the unity calibration created in the examples to match the image/videos.
- Added new field in the Input class, view_link. If the Input was successfully created it will contain an URL to view the input in the Annotell app.

### Bugfixes
- Fixed issue where `invalidate_inputs` did not properly discard response content.

## [1.0.4] - 2021-04-26
### Added
- Added support for providing metadata in the form of a flat KV-pair both on an input-level for all input types, as well as on a frame-level for all sequential input types.

### Changed
- Made SensorSpecification Optional for all input types

### Removed
- Removed sensor_settings from SensorSpecification. The pixel dimensions are now
  automatically inferred from videos and images.

## [1.0.3] - 2021-04-14
### Added
- Added an example for download_annotations
- Added check so that `input_list_id` and `project` is not used simultaneously when creating inputs
### Changed
- Made client and file_client internal
- Fixed bug where client sometimes didn't raise exception when http calls return error codes
- Bugfix where annoutil didn't work due to missing import
- Clarified examples with different images/videos for different sensors and frames.
### Removed
- Removed unnecessary parameters `frame_id` and `relative_timestamp` from `lidars_and_cameras`

## [1.0.1] - 2021-04-06
- Use backport of `dataclasses` to support python 3.6.

## [1.0.0] - 2021-03-23
- New major release of client. Reworked to be more internally consistent between input types, and use of project and batch identifiers across methods. See [docs](https://annotell.github.io/annotell-python/) for more info.
- `client.lidar_and_cameras.create` replaces `client.create_inputs_point_cloud_with_images`
- `client.cameras.create` replaces `client.upload_and_create_images_input_job`
- `client.annotations.get_annotations` replaces `client.download_annotations`

## [0.4.4] - 2021-03-02
- Remove unused dependency on annotell-cloud-storage

## [0.4.3] - 2021-02-16
- Fixed import bug in annoutil CLI tool.

## [0.4.2] - 2021-02-02

### Changed
- Changed url for the `get_calibration_data` method. Does not affect
usage of the method in any way.

## [0.4.1] - 2021-01-29

### Changed

- Removed unused property `deadline` from project
## [0.4.0] - 2021-01-28

### Changed

- Renamed method `upload_and_create_images_input_job` to `create_inputs_images`.
- Renamed method `list_projects` to `get_projects`.
- Renamed method `list_project_batches` to `get_project_batches`.
- Changed behaviour of method `download_annotations`. The previously optional argumnet `request_id` has been removed. Additionally, the return
  signature is changed to return a list of annotations for each input, instead of a dict as before.
- Behaviour of `get_inputs` has changed. It now receives `project` (identifier, not numerical id anymore), as well as three optional parameters `batch`, `external_ids` and `include_invalidated`. Returns all inputs belonging to the project, with the option of filtering on batch, external ID and whether or not including invalidated inputs. The returned list of classes had additional fields describing which batch each input belongs to, as well as their status (`created`, `processing`, `failed`, `invalidated`).
- Changed name of argument `input_ids` to `input_internal_ids` for method `invalidate_inputs`.
- Use backport of `dataclasses` to support python 3.6.
- Add missing dependency on `python-dateutil`.

### Removed

- Methods `count_inputs_for_external_ids`, `get_internal_ids_for_external_ids`, `mend_input_data`, `remove_inputs_from_input_list`, `list_input_lists`, `publish_batch`, `get_requests_for_request_ids`, `get_requests_for_input_lists`, `get_input_status`, `get_input_jobs_status`, `get_requests_for_project_id`, `get_datas_for_inputs_by_internal_ids` and `get_datas_for_inputs_by_external_ids` have all been removed.

## [0.3.12] - 2021-01-13

### Changed

- Removed getting started documentation from `README.md` and instead link to new docs.

## [0.3.11] - 2020-12-14

### Changed

- Deserialization bugfix in models for `InputBatch` and `InputBatch`.

## [0.3.10] - 2020-12-01

### Added

- Minor fix in annoutil

## [0.3.9] - 2020-11-26

### Added

- Bump of required python version to >=3.7
- New explicit models for `lidar` and `camera calibration` added.
- `publish_batch` which accepts project identifier and batch identifier and marks the batch as ready for annotation.

### Changed

- Deprecation warning for the old `lidar` and `camera calibration` models. No other change in functionality.

## [0.3.8] - 2020-11-13

### Added

- `get_inputs` which accepts a project ID or project identifier (external ID) and returns inputs connected to the project. `invalidated` filter parameter to optionally filter only invalidated inputs. Also exposed in annoutil as `annoutil projects 1 --invalidated`.

### Changed

- `invalidate_inputs` now accepts annotell `internal_ids (UUID)` instead of Annotell specific input ids.

## [0.3.7] - 2020-11-06

### Changed

- bug fix related to oauth session

## [0.3.6] - 2020-11-02

### Changed

- SLAM - add cuboid timespans, `dynamic_objects` not includes both `cuboids` and `cuboid_timespans`

## [0.3.5] - 2020-10-19

### Added

- Add support for `project` and `batch` identifiers for input request.
  Specifying project and batch adds input to specified batch.
  When only sending project, inputs are added to the latest open batch for the project.

### Deprecated

- `input_list_id` will be removed in the 0.4.x version

## [0.3.4] - 2020-09-10

### Changed

- SLAM - add required `sub_sequence_id` and optional `settings`

## [0.3.3] - 2020-09-10

### Changed

- SLAM - add required `sequence_id`

## [0.3.2] - 2020-09-01

### Changed

- SLAM - startTs and endTs not optional in Slam request

## [0.3.1] - 2020-07-16

### Changed

- If the upload of point clouds or images crashes and returns status code 429, 408 or 5xx the script will
  retry the upload before crashing. The default settings may be changed when initializing the `InputApiClient`
  by specifying values to the `max_upload_retry_attempts` and `max_upload_retry_wait_time` parameters.

## [0.3.0] - 2020-07-03

### Changed

- The method `create_inputs_point_cloud_with_images` in `InputApiClient` now takes an extra parameter: `dryrun: bool`.
  If set to `True` all the validation checks will be run but no inputJob will be created, and
  if it is set to `False` an inputJob will be created if the validation checks all pass.

### Bugfixes

- Fixed bug where the uploading of .csv files to GCS crashed if run on some windows machines.

## [0.2.9] - 2020-07-02

### Added

- New public method in `InputApiClient`: `count_inputs_for_external_ids`.

## [0.2.8] - 2020-06-30

### Added

- Docstrings for all public methods in the `InputApiClient` class

## [0.2.7] - 2020-06-29

### Added

- Require time specification to be send when posting slam requests

## [0.2.6] - 2020-06-26

### Changed

- Removed `CalibrationSpec` from `CalibratedSceneMetaData` and `SlamMetaData`. Updated
  so that `create_calibration_data` in `InputApiClient` only takes a `CalibrationSpec`
  as parameter.

## [0.2.5] - 2020-06-22

### Bugfixes

- Fixed issue where a path including a "~" would not expand correctly.

## [0.2.4] - 2020-06-17

### Changed

- Changed pointcloud_with_images model. Images and point clouds are now represented as `Image` and `PointCloud` containing filename and source. Consequently, `images_to_source` is removed from `SourceSpecification`.

### Added

- create Image inputs via `create_images_input_job`
- It's now possible to invalidate erroneous inputs via `invalidate_inputs`
- Support for removing specific inputs via `remove_inputs_from_input_list`
- SLAM support (not generally available)

### Bugfixes

- Fixed issue where annoutils would not deserialize datas correctly when querying datas by internalId

## [0.2.3] - 2020-04-21

### Changed

- Changed how timestamps are represented when receiving responses.

## [0.2.2] - 2020-04-17

### Added

- Methods `get_datas_for_inputs_by_internal_ids` and `get_datas_for_inputs_by_external_ids` can be used to get which `Data` are part of an `Input`, useful in order to check which images, lidar-files have been uploaded. Both are also available in the CLI via :

```console
$ annoutil inputs --get-datas <internal_ids>
$ annoutil inputs-externalid --get-datas <external_ids>
```

- Support has been added for `Kannala` camera types. Whenever adding calibration for `Kannala` undistortion coefficients must also be added.
- Calibration is now represented as a class and is no longer just a dictionary, making it easier to understand how the Annotell format is structured and used.

## [0.2.0] - 2020-04-16

### Changed

- Change constructor to disable legacy api token support and only accept an `auth` parameter

## [0.1.5] - 2020-04-07

### Added

- Method `get_input_jobs_status` now accepts lists of internal_ids and external_ids as arguments.
