"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StreamEventSource = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Use an stream as an event source for AWS Lambda.
 */
class StreamEventSource {
    constructor(props) {
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_event_sources_StreamEventSourceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, StreamEventSource);
            }
            throw error;
        }
    }
    enrichMappingOptions(options) {
        return {
            ...options,
            batchSize: this.props.batchSize || 100,
            bisectBatchOnError: this.props.bisectBatchOnError,
            startingPosition: this.props.startingPosition,
            reportBatchItemFailures: this.props.reportBatchItemFailures,
            maxBatchingWindow: this.props.maxBatchingWindow,
            maxRecordAge: this.props.maxRecordAge,
            retryAttempts: this.props.retryAttempts,
            parallelizationFactor: this.props.parallelizationFactor,
            onFailure: this.props.onFailure,
            tumblingWindow: this.props.tumblingWindow,
            enabled: this.props.enabled,
        };
    }
}
exports.StreamEventSource = StreamEventSource;
_a = JSII_RTTI_SYMBOL_1;
StreamEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.StreamEventSource", version: "1.168.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3RyZWFtLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsic3RyZWFtLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQStHQTs7R0FFRztBQUNILE1BQXNCLGlCQUFpQjtJQUNyQyxZQUF5QyxLQUE2QjtRQUE3QixVQUFLLEdBQUwsS0FBSyxDQUF3Qjs7Ozs7OytDQURsRCxpQkFBaUI7Ozs7S0FFcEM7SUFJUyxvQkFBb0IsQ0FBQyxPQUF5QztRQUN0RSxPQUFPO1lBQ0wsR0FBRyxPQUFPO1lBQ1YsU0FBUyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsU0FBUyxJQUFJLEdBQUc7WUFDdEMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxrQkFBa0I7WUFDakQsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxnQkFBZ0I7WUFDN0MsdUJBQXVCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyx1QkFBdUI7WUFDM0QsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUI7WUFDL0MsWUFBWSxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWTtZQUNyQyxhQUFhLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxhQUFhO1lBQ3ZDLHFCQUFxQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMscUJBQXFCO1lBQ3ZELFNBQVMsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLFNBQVM7WUFDL0IsY0FBYyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsY0FBYztZQUN6QyxPQUFPLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxPQUFPO1NBQzVCLENBQUM7S0FDSDs7QUFyQkgsOENBc0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuLyoqXG4gKiBUaGUgc2V0IG9mIHByb3BlcnRpZXMgZm9yIHN0cmVhbWluZyBldmVudCBzb3VyY2VzIHNoYXJlZCBieVxuICogRHluYW1vLCBLaW5lc2lzIGFuZCBLYWZrYS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBCYXNlU3RyZWFtRXZlbnRTb3VyY2VQcm9wc3tcbiAgLyoqXG4gICAqIFRoZSBsYXJnZXN0IG51bWJlciBvZiByZWNvcmRzIHRoYXQgQVdTIExhbWJkYSB3aWxsIHJldHJpZXZlIGZyb20geW91ciBldmVudFxuICAgKiBzb3VyY2UgYXQgdGhlIHRpbWUgb2YgaW52b2tpbmcgeW91ciBmdW5jdGlvbi4gWW91ciBmdW5jdGlvbiByZWNlaXZlcyBhblxuICAgKiBldmVudCB3aXRoIGFsbCB0aGUgcmV0cmlldmVkIHJlY29yZHMuXG4gICAqXG4gICAqIFZhbGlkIFJhbmdlOlxuICAgKiAqIE1pbmltdW0gdmFsdWUgb2YgMVxuICAgKiAqIE1heGltdW0gdmFsdWUgb2Y6XG4gICAqICAgKiAxMDAwIGZvciB7QGxpbmsgRHluYW1vRXZlbnRTb3VyY2V9XG4gICAqICAgKiAxMDAwMCBmb3Ige0BsaW5rIEtpbmVzaXNFdmVudFNvdXJjZX0sIHtAbGluayBNYW5hZ2VkS2Fma2FFdmVudFNvdXJjZX0gYW5kIHtAbGluayBTZWxmTWFuYWdlZEthZmthRXZlbnRTb3VyY2V9XG4gICAqXG4gICAqIEBkZWZhdWx0IDEwMFxuICAgKi9cbiAgcmVhZG9ubHkgYmF0Y2hTaXplPzogbnVtYmVyO1xuXG4gIC8qKlxuICAgKiBXaGVyZSB0byBiZWdpbiBjb25zdW1pbmcgdGhlIHN0cmVhbS5cbiAgICovXG4gIHJlYWRvbmx5IHN0YXJ0aW5nUG9zaXRpb246IGxhbWJkYS5TdGFydGluZ1Bvc2l0aW9uO1xuXG4gIC8qKlxuICAgKiBUaGUgbWF4aW11bSBhbW91bnQgb2YgdGltZSB0byBnYXRoZXIgcmVjb3JkcyBiZWZvcmUgaW52b2tpbmcgdGhlIGZ1bmN0aW9uLlxuICAgKiBNYXhpbXVtIG9mIER1cmF0aW9uLm1pbnV0ZXMoNSlcbiAgICpcbiAgICogQGRlZmF1bHQgRHVyYXRpb24uc2Vjb25kcygwKVxuICAgKi9cbiAgcmVhZG9ubHkgbWF4QmF0Y2hpbmdXaW5kb3c/OiBEdXJhdGlvbjtcblxuICAvKipcbiAgICogSWYgdGhlIHN0cmVhbSBldmVudCBzb3VyY2UgbWFwcGluZyBzaG91bGQgYmUgZW5hYmxlZC5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW47XG59XG5cbi8qKlxuICogVGhlIHNldCBvZiBwcm9wZXJ0aWVzIGZvciBzdHJlYW1pbmcgZXZlbnQgc291cmNlcyBzaGFyZWQgYnlcbiAqIER5bmFtbyBhbmQgS2luZXNpcy5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBTdHJlYW1FdmVudFNvdXJjZVByb3BzIGV4dGVuZHMgQmFzZVN0cmVhbUV2ZW50U291cmNlUHJvcHMge1xuICAvKipcbiAgICogSWYgdGhlIGZ1bmN0aW9uIHJldHVybnMgYW4gZXJyb3IsIHNwbGl0IHRoZSBiYXRjaCBpbiB0d28gYW5kIHJldHJ5LlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgYmlzZWN0QmF0Y2hPbkVycm9yPzogYm9vbGVhbjtcblxuICAvKipcbiAgICogVGhlIG1heGltdW0gYWdlIG9mIGEgcmVjb3JkIHRoYXQgTGFtYmRhIHNlbmRzIHRvIGEgZnVuY3Rpb24gZm9yIHByb2Nlc3NpbmcuXG4gICAqIFZhbGlkIFJhbmdlOlxuICAgKiAqIE1pbmltdW0gdmFsdWUgb2YgNjAgc2Vjb25kc1xuICAgKiAqIE1heGltdW0gdmFsdWUgb2YgNyBkYXlzXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIHJldGVudGlvbiBwZXJpb2QgY29uZmlndXJlZCBvbiB0aGUgc3RyZWFtXG4gICAqL1xuICByZWFkb25seSBtYXhSZWNvcmRBZ2U/OiBEdXJhdGlvbjtcblxuICAvKipcbiAgICogTWF4aW11bSBudW1iZXIgb2YgcmV0cnkgYXR0ZW1wdHNcbiAgICogVmFsaWQgUmFuZ2U6XG4gICAqICogTWluaW11bSB2YWx1ZSBvZiAwXG4gICAqICogTWF4aW11bSB2YWx1ZSBvZiAxMDAwMFxuICAgKlxuICAgKiBAZGVmYXVsdCAtIHJldHJ5IHVudGlsIHRoZSByZWNvcmQgZXhwaXJlc1xuICAgKi9cbiAgcmVhZG9ubHkgcmV0cnlBdHRlbXB0cz86IG51bWJlcjtcblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBiYXRjaGVzIHRvIHByb2Nlc3MgZnJvbSBlYWNoIHNoYXJkIGNvbmN1cnJlbnRseS5cbiAgICogVmFsaWQgUmFuZ2U6XG4gICAqICogTWluaW11bSB2YWx1ZSBvZiAxXG4gICAqICogTWF4aW11bSB2YWx1ZSBvZiAxMFxuICAgKlxuICAgKiBAZGVmYXVsdCAxXG4gICAqL1xuICByZWFkb25seSBwYXJhbGxlbGl6YXRpb25GYWN0b3I/OiBudW1iZXI7XG5cbiAgLyoqXG4gICAqIEFsbG93IGZ1bmN0aW9ucyB0byByZXR1cm4gcGFydGlhbGx5IHN1Y2Nlc3NmdWwgcmVzcG9uc2VzIGZvciBhIGJhdGNoIG9mIHJlY29yZHMuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2xhbWJkYS9sYXRlc3QvZGcvd2l0aC1kZGIuaHRtbCNzZXJ2aWNlcy1kZGItYmF0Y2hmYWlsdXJlcmVwb3J0aW5nXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSByZXBvcnRCYXRjaEl0ZW1GYWlsdXJlcz86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFRoZSBzaXplIG9mIHRoZSB0dW1ibGluZyB3aW5kb3dzIHRvIGdyb3VwIHJlY29yZHMgc2VudCB0byBEeW5hbW9EQiBvciBLaW5lc2lzXG4gICAqIFZhbGlkIFJhbmdlOiAwIC0gMTUgbWludXRlc1xuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHR1bWJsaW5nV2luZG93PzogRHVyYXRpb247XG5cbiAgLyoqXG4gICAqIEFuIEFtYXpvbiBTUVMgcXVldWUgb3IgQW1hem9uIFNOUyB0b3BpYyBkZXN0aW5hdGlvbiBmb3IgZGlzY2FyZGVkIHJlY29yZHMuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gZGlzY2FyZGVkIHJlY29yZHMgYXJlIGlnbm9yZWRcbiAgICovXG4gIHJlYWRvbmx5IG9uRmFpbHVyZT86IGxhbWJkYS5JRXZlbnRTb3VyY2VEbHE7XG59XG5cbi8qKlxuICogVXNlIGFuIHN0cmVhbSBhcyBhbiBldmVudCBzb3VyY2UgZm9yIEFXUyBMYW1iZGEuXG4gKi9cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBTdHJlYW1FdmVudFNvdXJjZSBpbXBsZW1lbnRzIGxhbWJkYS5JRXZlbnRTb3VyY2Uge1xuICBwcm90ZWN0ZWQgY29uc3RydWN0b3IocHJvdGVjdGVkIHJlYWRvbmx5IHByb3BzOiBTdHJlYW1FdmVudFNvdXJjZVByb3BzKSB7XG4gIH1cblxuICBwdWJsaWMgYWJzdHJhY3QgYmluZChfdGFyZ2V0OiBsYW1iZGEuSUZ1bmN0aW9uKTogdm9pZDtcblxuICBwcm90ZWN0ZWQgZW5yaWNoTWFwcGluZ09wdGlvbnMob3B0aW9uczogbGFtYmRhLkV2ZW50U291cmNlTWFwcGluZ09wdGlvbnMpOiBsYW1iZGEuRXZlbnRTb3VyY2VNYXBwaW5nT3B0aW9ucyB7XG4gICAgcmV0dXJuIHtcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgICBiYXRjaFNpemU6IHRoaXMucHJvcHMuYmF0Y2hTaXplIHx8IDEwMCxcbiAgICAgIGJpc2VjdEJhdGNoT25FcnJvcjogdGhpcy5wcm9wcy5iaXNlY3RCYXRjaE9uRXJyb3IsXG4gICAgICBzdGFydGluZ1Bvc2l0aW9uOiB0aGlzLnByb3BzLnN0YXJ0aW5nUG9zaXRpb24sXG4gICAgICByZXBvcnRCYXRjaEl0ZW1GYWlsdXJlczogdGhpcy5wcm9wcy5yZXBvcnRCYXRjaEl0ZW1GYWlsdXJlcyxcbiAgICAgIG1heEJhdGNoaW5nV2luZG93OiB0aGlzLnByb3BzLm1heEJhdGNoaW5nV2luZG93LFxuICAgICAgbWF4UmVjb3JkQWdlOiB0aGlzLnByb3BzLm1heFJlY29yZEFnZSxcbiAgICAgIHJldHJ5QXR0ZW1wdHM6IHRoaXMucHJvcHMucmV0cnlBdHRlbXB0cyxcbiAgICAgIHBhcmFsbGVsaXphdGlvbkZhY3RvcjogdGhpcy5wcm9wcy5wYXJhbGxlbGl6YXRpb25GYWN0b3IsXG4gICAgICBvbkZhaWx1cmU6IHRoaXMucHJvcHMub25GYWlsdXJlLFxuICAgICAgdHVtYmxpbmdXaW5kb3c6IHRoaXMucHJvcHMudHVtYmxpbmdXaW5kb3csXG4gICAgICBlbmFibGVkOiB0aGlzLnByb3BzLmVuYWJsZWQsXG4gICAgfTtcbiAgfVxufVxuIl19