"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
const ecs = require("@aws-cdk/aws-ecs");
const events = require("@aws-cdk/aws-events");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename), {
    env: { account: core_1.Aws.ACCOUNT_ID, region: 'us-east-1' },
});
stack.templateOptions.description = 'Integration Test with new VPC, Service and Existing Bucket';
const existingVpc = core_2.getTestVpc(stack);
const image = ecs.ContainerImage.fromRegistry('nginx');
const [testService, testContainer] = core_2.CreateFargateService(stack, 'test', existingVpc, undefined, undefined, undefined, undefined, { image });
const existingEventBus = new events.EventBus(stack, 'existing-event-bus', { eventBusName: 'test' });
const testProps = {
    publicApi: true,
    existingVpc,
    existingEventBusInterface: existingEventBus,
    existingContainerDefinitionObject: testContainer,
    existingFargateServiceObject: testService,
    eventBusEnvironmentVariableName: 'CUSTOM_ARN',
};
new lib_1.FargateToEventbridge(stack, 'test-construct', testProps);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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