# Generated by Django 3.1.4 on 2020-12-30 00:44

import datetime
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("groupmanagement", "0015_make_descriptions_great_again"),
        ("eveonline", "0012_index_additions"),
    ]

    operations = [
        migrations.CreateModel(
            name="General",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "verbose_name": "Fleet Finder",
                "permissions": (
                    ("access_fleetfinder", "Can access the Fleet Finder app"),
                    ("manage_fleets", "Can manage fleets"),
                ),
                "managed": False,
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="Fleet",
            fields=[
                ("fleet_id", models.BigIntegerField(primary_key=True, serialize=False)),
                ("name", models.CharField(default="", max_length=50)),
                ("created_at", models.DateTimeField()),
                ("motd", models.CharField(max_length=4000)),
                ("is_free_move", models.BooleanField()),
                (
                    "fleet_commander",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="+",
                        to="eveonline.evecharacter",
                    ),
                ),
                (
                    "groups",
                    models.ManyToManyField(
                        help_text="Group listed here will be able to join the fleet",
                        related_name="restricted_groups",
                        to="groupmanagement.AuthGroup",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
        migrations.CreateModel(
            name="FleetInformation",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("ship_type_name", models.CharField(max_length=100)),
                ("count", models.IntegerField()),
                ("date", models.DateTimeField(default=datetime.datetime.now)),
                (
                    "fleet",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="fleetfinder.fleet",
                    ),
                ),
            ],
            options={
                "default_permissions": (),
            },
        ),
    ]
