"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Lamda Function as the destination for a log subscription
 */
class LambdaDestination {
    constructor(fn) {
        this.fn = fn;
    }
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        this.fn.addPermission('CanInvokeLambda', {
            principal: new iam.ServicePrincipal('logs.amazonaws.com'),
            sourceArn: arn,
            // Using SubScription Filter as scope is okay, since every Subscription Filter has only
            // one destination.
            scope,
        });
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFtYmRhLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsibGFtYmRhLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLHdDQUF3QztBQUt4Qzs7R0FFRztBQUNILE1BQWEsaUJBQWlCO0lBQzVCLFlBQTZCLEVBQW9CO1FBQXBCLE9BQUUsR0FBRixFQUFFLENBQWtCO0lBQ2pELENBQUM7SUFFTSxJQUFJLENBQUMsS0FBZ0IsRUFBRSxRQUF3QjtRQUNwRCxNQUFNLEdBQUcsR0FBRyxRQUFRLENBQUMsV0FBVyxDQUFDO1FBRWpDLElBQUksQ0FBQyxFQUFFLENBQUMsYUFBYSxDQUFDLGlCQUFpQixFQUFFO1lBQ3ZDLFNBQVMsRUFBRSxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQkFBb0IsQ0FBQztZQUN6RCxTQUFTLEVBQUUsR0FBRztZQUNkLHVGQUF1RjtZQUN2RixtQkFBbUI7WUFDbkIsS0FBSztTQUNOLENBQUMsQ0FBQztRQUNILE9BQU8sRUFBRSxHQUFHLEVBQUUsSUFBSSxDQUFDLEVBQUUsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUN0QyxDQUFDO0NBQ0Y7QUFoQkQsOENBZ0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgaWFtIGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgbGFtYmRhIGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0ICogYXMgbG9ncyBmcm9tICdAYXdzLWNkay9hd3MtbG9ncyc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuLyoqXG4gKiBVc2UgYSBMYW1kYSBGdW5jdGlvbiBhcyB0aGUgZGVzdGluYXRpb24gZm9yIGEgbG9nIHN1YnNjcmlwdGlvblxuICovXG5leHBvcnQgY2xhc3MgTGFtYmRhRGVzdGluYXRpb24gaW1wbGVtZW50cyBsb2dzLklMb2dTdWJzY3JpcHRpb25EZXN0aW5hdGlvbiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgZm46IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QsIGxvZ0dyb3VwOiBsb2dzLklMb2dHcm91cCk6IGxvZ3MuTG9nU3Vic2NyaXB0aW9uRGVzdGluYXRpb25Db25maWcge1xuICAgIGNvbnN0IGFybiA9IGxvZ0dyb3VwLmxvZ0dyb3VwQXJuO1xuXG4gICAgdGhpcy5mbi5hZGRQZXJtaXNzaW9uKCdDYW5JbnZva2VMYW1iZGEnLCB7XG4gICAgICBwcmluY2lwYWw6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnbG9ncy5hbWF6b25hd3MuY29tJyksXG4gICAgICBzb3VyY2VBcm46IGFybixcbiAgICAgIC8vIFVzaW5nIFN1YlNjcmlwdGlvbiBGaWx0ZXIgYXMgc2NvcGUgaXMgb2theSwgc2luY2UgZXZlcnkgU3Vic2NyaXB0aW9uIEZpbHRlciBoYXMgb25seVxuICAgICAgLy8gb25lIGRlc3RpbmF0aW9uLlxuICAgICAgc2NvcGUsXG4gICAgfSk7XG4gICAgcmV0dXJuIHsgYXJuOiB0aGlzLmZuLmZ1bmN0aW9uQXJuIH07XG4gIH1cbn1cbiJdfQ==