"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Kinesis stream as the destination for a log subscription
 */
class KinesisDestination {
    constructor(stream) {
        this.stream = stream;
    }
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = scope.node.tryFindChild(id) || new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
//# sourceMappingURL=data:application/json;base64,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