import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 */
export interface CfnDeliveryStreamProps {
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamEncryptionConfigurationInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput
     * @external
     */
    readonly deliveryStreamEncryptionConfigurationInput?: CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname
     * @external
     */
    readonly deliveryStreamName?: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype
     * @external
     */
    readonly deliveryStreamType?: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration
     * @external
     */
    readonly elasticsearchDestinationConfiguration?: CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration
     * @external
     */
    readonly extendedS3DestinationConfiguration?: CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.HttpEndpointDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration
     * @external
     */
    readonly httpEndpointDestinationConfiguration?: CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration
     * @external
     */
    readonly kinesisStreamSourceConfiguration?: CfnDeliveryStream.KinesisStreamSourceConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration
     * @external
     */
    readonly redshiftDestinationConfiguration?: CfnDeliveryStream.RedshiftDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration
     * @external
     */
    readonly s3DestinationConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration
     * @external
     */
    readonly splunkDestinationConfiguration?: CfnDeliveryStream.SplunkDestinationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare class CfnDeliveryStream extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::KinesisFirehose::DeliveryStream";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeliveryStream;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamEncryptionConfigurationInput`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput
     * @external
     */
    deliveryStreamEncryptionConfigurationInput: CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamname
     * @external
     */
    deliveryStreamName: string | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.DeliveryStreamType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-deliverystreamtype
     * @external
     */
    deliveryStreamType: string | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ElasticsearchDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration
     * @external
     */
    elasticsearchDestinationConfiguration: CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.ExtendedS3DestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration
     * @external
     */
    extendedS3DestinationConfiguration: CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.HttpEndpointDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration
     * @external
     */
    httpEndpointDestinationConfiguration: CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.KinesisStreamSourceConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration
     * @external
     */
    kinesisStreamSourceConfiguration: CfnDeliveryStream.KinesisStreamSourceConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.RedshiftDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration
     * @external
     */
    redshiftDestinationConfiguration: CfnDeliveryStream.RedshiftDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.S3DestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration
     * @external
     */
    s3DestinationConfiguration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.SplunkDestinationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration
     * @external
     */
    splunkDestinationConfiguration: CfnDeliveryStream.SplunkDestinationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::KinesisFirehose::DeliveryStream.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html#cfn-kinesisfirehose-deliverystream-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::KinesisFirehose::DeliveryStream`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeliveryStreamProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html
     * @external
     */
    interface BufferingHintsProperty {
        /**
         * `CfnDeliveryStream.BufferingHintsProperty.IntervalInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-intervalinseconds
         * @external
         */
        readonly intervalInSeconds?: number;
        /**
         * `CfnDeliveryStream.BufferingHintsProperty.SizeInMBs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-bufferinghints.html#cfn-kinesisfirehose-deliverystream-bufferinghints-sizeinmbs
         * @external
         */
        readonly sizeInMBs?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html
     * @external
     */
    interface CloudWatchLoggingOptionsProperty {
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.LogGroupName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-loggroupname
         * @external
         */
        readonly logGroupName?: string;
        /**
         * `CfnDeliveryStream.CloudWatchLoggingOptionsProperty.LogStreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-cloudwatchloggingoptions.html#cfn-kinesisfirehose-deliverystream-cloudwatchloggingoptions-logstreamname
         * @external
         */
        readonly logStreamName?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html
     * @external
     */
    interface CopyCommandProperty {
        /**
         * `CfnDeliveryStream.CopyCommandProperty.CopyOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-copyoptions
         * @external
         */
        readonly copyOptions?: string;
        /**
         * `CfnDeliveryStream.CopyCommandProperty.DataTableColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablecolumns
         * @external
         */
        readonly dataTableColumns?: string;
        /**
         * `CfnDeliveryStream.CopyCommandProperty.DataTableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-copycommand.html#cfn-kinesisfirehose-deliverystream-copycommand-datatablename
         * @external
         */
        readonly dataTableName: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html
     * @external
     */
    interface DataFormatConversionConfigurationProperty {
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.InputFormatConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-inputformatconfiguration
         * @external
         */
        readonly inputFormatConfiguration?: CfnDeliveryStream.InputFormatConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.OutputFormatConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-outputformatconfiguration
         * @external
         */
        readonly outputFormatConfiguration?: CfnDeliveryStream.OutputFormatConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DataFormatConversionConfigurationProperty.SchemaConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-dataformatconversionconfiguration.html#cfn-kinesisfirehose-deliverystream-dataformatconversionconfiguration-schemaconfiguration
         * @external
         */
        readonly schemaConfiguration?: CfnDeliveryStream.SchemaConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html
     * @external
     */
    interface DeliveryStreamEncryptionConfigurationInputProperty {
        /**
         * `CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty.KeyARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keyarn
         * @external
         */
        readonly keyArn?: string;
        /**
         * `CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty.KeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput.html#cfn-kinesisfirehose-deliverystream-deliverystreamencryptionconfigurationinput-keytype
         * @external
         */
        readonly keyType: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html
     * @external
     */
    interface DeserializerProperty {
        /**
         * `CfnDeliveryStream.DeserializerProperty.HiveJsonSerDe`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-hivejsonserde
         * @external
         */
        readonly hiveJsonSerDe?: CfnDeliveryStream.HiveJsonSerDeProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.DeserializerProperty.OpenXJsonSerDe`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-deserializer.html#cfn-kinesisfirehose-deliverystream-deserializer-openxjsonserde
         * @external
         */
        readonly openXJsonSerDe?: CfnDeliveryStream.OpenXJsonSerDeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html
     * @external
     */
    interface ElasticsearchBufferingHintsProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchBufferingHintsProperty.IntervalInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-intervalinseconds
         * @external
         */
        readonly intervalInSeconds?: number;
        /**
         * `CfnDeliveryStream.ElasticsearchBufferingHintsProperty.SizeInMBs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchbufferinghints.html#cfn-kinesisfirehose-deliverystream-elasticsearchbufferinghints-sizeinmbs
         * @external
         */
        readonly sizeInMBs?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html
     * @external
     */
    interface ElasticsearchDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.BufferingHints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-bufferinghints
         * @external
         */
        readonly bufferingHints?: CfnDeliveryStream.ElasticsearchBufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-cloudwatchloggingoptions
         * @external
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.ClusterEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-clusterendpoint
         * @external
         */
        readonly clusterEndpoint?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.DomainARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-domainarn
         * @external
         */
        readonly domainArn?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.IndexName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexname
         * @external
         */
        readonly indexName: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.IndexRotationPeriod`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-indexrotationperiod
         * @external
         */
        readonly indexRotationPeriod?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-processingconfiguration
         * @external
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.RetryOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-retryoptions
         * @external
         */
        readonly retryOptions?: CfnDeliveryStream.ElasticsearchRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.S3BackupMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3backupmode
         * @external
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.S3Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-s3configuration
         * @external
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.TypeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-typename
         * @external
         */
        readonly typeName?: string;
        /**
         * `CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty.VpcConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-elasticsearchdestinationconfiguration-vpcconfiguration
         * @external
         */
        readonly vpcConfiguration?: CfnDeliveryStream.VpcConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html
     * @external
     */
    interface ElasticsearchRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.ElasticsearchRetryOptionsProperty.DurationInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-elasticsearchretryoptions.html#cfn-kinesisfirehose-deliverystream-elasticsearchretryoptions-durationinseconds
         * @external
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html
     * @external
     */
    interface EncryptionConfigurationProperty {
        /**
         * `CfnDeliveryStream.EncryptionConfigurationProperty.KMSEncryptionConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-kmsencryptionconfig
         * @external
         */
        readonly kmsEncryptionConfig?: CfnDeliveryStream.KMSEncryptionConfigProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.EncryptionConfigurationProperty.NoEncryptionConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-encryptionconfiguration.html#cfn-kinesisfirehose-deliverystream-encryptionconfiguration-noencryptionconfig
         * @external
         */
        readonly noEncryptionConfig?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html
     * @external
     */
    interface ExtendedS3DestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.BucketARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bucketarn
         * @external
         */
        readonly bucketArn: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.BufferingHints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-bufferinghints
         * @external
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-cloudwatchloggingoptions
         * @external
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.CompressionFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-compressionformat
         * @external
         */
        readonly compressionFormat?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.DataFormatConversionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-dataformatconversionconfiguration
         * @external
         */
        readonly dataFormatConversionConfiguration?: CfnDeliveryStream.DataFormatConversionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.EncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-encryptionconfiguration
         * @external
         */
        readonly encryptionConfiguration?: CfnDeliveryStream.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.ErrorOutputPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-erroroutputprefix
         * @external
         */
        readonly errorOutputPrefix?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-processingconfiguration
         * @external
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.S3BackupConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupconfiguration
         * @external
         */
        readonly s3BackupConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty.S3BackupMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-extendeds3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-extendeds3destinationconfiguration-s3backupmode
         * @external
         */
        readonly s3BackupMode?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html
     * @external
     */
    interface HiveJsonSerDeProperty {
        /**
         * `CfnDeliveryStream.HiveJsonSerDeProperty.TimestampFormats`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-hivejsonserde.html#cfn-kinesisfirehose-deliverystream-hivejsonserde-timestampformats
         * @external
         */
        readonly timestampFormats?: string[];
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html
     * @external
     */
    interface HttpEndpointCommonAttributeProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointCommonAttributeProperty.AttributeName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributename
         * @external
         */
        readonly attributeName: string;
        /**
         * `CfnDeliveryStream.HttpEndpointCommonAttributeProperty.AttributeValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointcommonattribute.html#cfn-kinesisfirehose-deliverystream-httpendpointcommonattribute-attributevalue
         * @external
         */
        readonly attributeValue: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html
     * @external
     */
    interface HttpEndpointConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.AccessKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-accesskey
         * @external
         */
        readonly accessKey?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-name
         * @external
         */
        readonly name?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointConfigurationProperty.Url`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointconfiguration-url
         * @external
         */
        readonly url: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html
     * @external
     */
    interface HttpEndpointDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.BufferingHints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-bufferinghints
         * @external
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-cloudwatchloggingoptions
         * @external
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.EndpointConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-endpointconfiguration
         * @external
         */
        readonly endpointConfiguration: CfnDeliveryStream.HttpEndpointConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-processingconfiguration
         * @external
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RequestConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-requestconfiguration
         * @external
         */
        readonly requestConfiguration?: CfnDeliveryStream.HttpEndpointRequestConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RetryOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-retryoptions
         * @external
         */
        readonly retryOptions?: CfnDeliveryStream.RetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.S3BackupMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3backupmode
         * @external
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty.S3Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointdestinationconfiguration-s3configuration
         * @external
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html
     * @external
     */
    interface HttpEndpointRequestConfigurationProperty {
        /**
         * `CfnDeliveryStream.HttpEndpointRequestConfigurationProperty.CommonAttributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-commonattributes
         * @external
         */
        readonly commonAttributes?: Array<CfnDeliveryStream.HttpEndpointCommonAttributeProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.HttpEndpointRequestConfigurationProperty.ContentEncoding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-httpendpointrequestconfiguration.html#cfn-kinesisfirehose-deliverystream-httpendpointrequestconfiguration-contentencoding
         * @external
         */
        readonly contentEncoding?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html
     * @external
     */
    interface InputFormatConfigurationProperty {
        /**
         * `CfnDeliveryStream.InputFormatConfigurationProperty.Deserializer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-inputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-inputformatconfiguration-deserializer
         * @external
         */
        readonly deserializer?: CfnDeliveryStream.DeserializerProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html
     * @external
     */
    interface KMSEncryptionConfigProperty {
        /**
         * `CfnDeliveryStream.KMSEncryptionConfigProperty.AWSKMSKeyARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kmsencryptionconfig.html#cfn-kinesisfirehose-deliverystream-kmsencryptionconfig-awskmskeyarn
         * @external
         */
        readonly awskmsKeyArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html
     * @external
     */
    interface KinesisStreamSourceConfigurationProperty {
        /**
         * `CfnDeliveryStream.KinesisStreamSourceConfigurationProperty.KinesisStreamARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-kinesisstreamarn
         * @external
         */
        readonly kinesisStreamArn: string;
        /**
         * `CfnDeliveryStream.KinesisStreamSourceConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html#cfn-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html
     * @external
     */
    interface OpenXJsonSerDeProperty {
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.CaseInsensitive`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-caseinsensitive
         * @external
         */
        readonly caseInsensitive?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.ColumnToJsonKeyMappings`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-columntojsonkeymappings
         * @external
         */
        readonly columnToJsonKeyMappings?: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OpenXJsonSerDeProperty.ConvertDotsInJsonKeysToUnderscores`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-openxjsonserde.html#cfn-kinesisfirehose-deliverystream-openxjsonserde-convertdotsinjsonkeystounderscores
         * @external
         */
        readonly convertDotsInJsonKeysToUnderscores?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html
     * @external
     */
    interface OrcSerDeProperty {
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BlockSizeBytes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-blocksizebytes
         * @external
         */
        readonly blockSizeBytes?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BloomFilterColumns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfiltercolumns
         * @external
         */
        readonly bloomFilterColumns?: string[];
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.BloomFilterFalsePositiveProbability`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-bloomfilterfalsepositiveprobability
         * @external
         */
        readonly bloomFilterFalsePositiveProbability?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.Compression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-compression
         * @external
         */
        readonly compression?: string;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.DictionaryKeyThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-dictionarykeythreshold
         * @external
         */
        readonly dictionaryKeyThreshold?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.EnablePadding`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-enablepadding
         * @external
         */
        readonly enablePadding?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.FormatVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-formatversion
         * @external
         */
        readonly formatVersion?: string;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.PaddingTolerance`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-paddingtolerance
         * @external
         */
        readonly paddingTolerance?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.RowIndexStride`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-rowindexstride
         * @external
         */
        readonly rowIndexStride?: number;
        /**
         * `CfnDeliveryStream.OrcSerDeProperty.StripeSizeBytes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-orcserde.html#cfn-kinesisfirehose-deliverystream-orcserde-stripesizebytes
         * @external
         */
        readonly stripeSizeBytes?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html
     * @external
     */
    interface OutputFormatConfigurationProperty {
        /**
         * `CfnDeliveryStream.OutputFormatConfigurationProperty.Serializer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-outputformatconfiguration.html#cfn-kinesisfirehose-deliverystream-outputformatconfiguration-serializer
         * @external
         */
        readonly serializer?: CfnDeliveryStream.SerializerProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html
     * @external
     */
    interface ParquetSerDeProperty {
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.BlockSizeBytes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-blocksizebytes
         * @external
         */
        readonly blockSizeBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.Compression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-compression
         * @external
         */
        readonly compression?: string;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.EnableDictionaryCompression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-enabledictionarycompression
         * @external
         */
        readonly enableDictionaryCompression?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.MaxPaddingBytes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-maxpaddingbytes
         * @external
         */
        readonly maxPaddingBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.PageSizeBytes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-pagesizebytes
         * @external
         */
        readonly pageSizeBytes?: number;
        /**
         * `CfnDeliveryStream.ParquetSerDeProperty.WriterVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-parquetserde.html#cfn-kinesisfirehose-deliverystream-parquetserde-writerversion
         * @external
         */
        readonly writerVersion?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html
     * @external
     */
    interface ProcessingConfigurationProperty {
        /**
         * `CfnDeliveryStream.ProcessingConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ProcessingConfigurationProperty.Processors`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processingconfiguration.html#cfn-kinesisfirehose-deliverystream-processingconfiguration-processors
         * @external
         */
        readonly processors?: Array<CfnDeliveryStream.ProcessorProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html
     * @external
     */
    interface ProcessorProperty {
        /**
         * `CfnDeliveryStream.ProcessorProperty.Parameters`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-parameters
         * @external
         */
        readonly parameters?: Array<CfnDeliveryStream.ProcessorParameterProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.ProcessorProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processor.html#cfn-kinesisfirehose-deliverystream-processor-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html
     * @external
     */
    interface ProcessorParameterProperty {
        /**
         * `CfnDeliveryStream.ProcessorParameterProperty.ParameterName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametername
         * @external
         */
        readonly parameterName: string;
        /**
         * `CfnDeliveryStream.ProcessorParameterProperty.ParameterValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-processorparameter.html#cfn-kinesisfirehose-deliverystream-processorparameter-parametervalue
         * @external
         */
        readonly parameterValue: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html
     * @external
     */
    interface RedshiftDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-cloudwatchloggingoptions
         * @external
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.ClusterJDBCURL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-clusterjdbcurl
         * @external
         */
        readonly clusterJdbcurl: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.CopyCommand`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-copycommand
         * @external
         */
        readonly copyCommand: CfnDeliveryStream.CopyCommandProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-processingconfiguration
         * @external
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.RetryOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-retryoptions
         * @external
         */
        readonly retryOptions?: CfnDeliveryStream.RedshiftRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3BackupConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupconfiguration
         * @external
         */
        readonly s3BackupConfiguration?: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3BackupMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3backupmode
         * @external
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.S3Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-s3configuration
         * @external
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.RedshiftDestinationConfigurationProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-redshiftdestinationconfiguration-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html
     * @external
     */
    interface RedshiftRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.RedshiftRetryOptionsProperty.DurationInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-redshiftretryoptions.html#cfn-kinesisfirehose-deliverystream-redshiftretryoptions-durationinseconds
         * @external
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html
     * @external
     */
    interface RetryOptionsProperty {
        /**
         * `CfnDeliveryStream.RetryOptionsProperty.DurationInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-retryoptions.html#cfn-kinesisfirehose-deliverystream-retryoptions-durationinseconds
         * @external
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html
     * @external
     */
    interface S3DestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.BucketARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bucketarn
         * @external
         */
        readonly bucketArn: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.BufferingHints`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-bufferinghints
         * @external
         */
        readonly bufferingHints?: CfnDeliveryStream.BufferingHintsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-cloudwatchloggingoptions
         * @external
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.CompressionFormat`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-compressionformat
         * @external
         */
        readonly compressionFormat?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.EncryptionConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-encryptionconfiguration
         * @external
         */
        readonly encryptionConfiguration?: CfnDeliveryStream.EncryptionConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.ErrorOutputPrefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-erroroutputprefix
         * @external
         */
        readonly errorOutputPrefix?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-prefix
         * @external
         */
        readonly prefix?: string;
        /**
         * `CfnDeliveryStream.S3DestinationConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-s3destinationconfiguration.html#cfn-kinesisfirehose-deliverystream-s3destinationconfiguration-rolearn
         * @external
         */
        readonly roleArn: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html
     * @external
     */
    interface SchemaConfigurationProperty {
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.CatalogId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-catalogid
         * @external
         */
        readonly catalogId?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.DatabaseName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-databasename
         * @external
         */
        readonly databaseName?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-region
         * @external
         */
        readonly region?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-rolearn
         * @external
         */
        readonly roleArn?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-tablename
         * @external
         */
        readonly tableName?: string;
        /**
         * `CfnDeliveryStream.SchemaConfigurationProperty.VersionId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-schemaconfiguration.html#cfn-kinesisfirehose-deliverystream-schemaconfiguration-versionid
         * @external
         */
        readonly versionId?: string;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html
     * @external
     */
    interface SerializerProperty {
        /**
         * `CfnDeliveryStream.SerializerProperty.OrcSerDe`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-orcserde
         * @external
         */
        readonly orcSerDe?: CfnDeliveryStream.OrcSerDeProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SerializerProperty.ParquetSerDe`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-serializer.html#cfn-kinesisfirehose-deliverystream-serializer-parquetserde
         * @external
         */
        readonly parquetSerDe?: CfnDeliveryStream.ParquetSerDeProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html
     * @external
     */
    interface SplunkDestinationConfigurationProperty {
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.CloudWatchLoggingOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-cloudwatchloggingoptions
         * @external
         */
        readonly cloudWatchLoggingOptions?: CfnDeliveryStream.CloudWatchLoggingOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECAcknowledgmentTimeoutInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecacknowledgmenttimeoutinseconds
         * @external
         */
        readonly hecAcknowledgmentTimeoutInSeconds?: number;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECEndpoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecendpoint
         * @external
         */
        readonly hecEndpoint: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECEndpointType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hecendpointtype
         * @external
         */
        readonly hecEndpointType: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.HECToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-hectoken
         * @external
         */
        readonly hecToken: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.ProcessingConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-processingconfiguration
         * @external
         */
        readonly processingConfiguration?: CfnDeliveryStream.ProcessingConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.RetryOptions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-retryoptions
         * @external
         */
        readonly retryOptions?: CfnDeliveryStream.SplunkRetryOptionsProperty | cdk.IResolvable;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.S3BackupMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-s3backupmode
         * @external
         */
        readonly s3BackupMode?: string;
        /**
         * `CfnDeliveryStream.SplunkDestinationConfigurationProperty.S3Configuration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkdestinationconfiguration.html#cfn-kinesisfirehose-deliverystream-splunkdestinationconfiguration-s3configuration
         * @external
         */
        readonly s3Configuration: CfnDeliveryStream.S3DestinationConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkretryoptions.html
     * @external
     */
    interface SplunkRetryOptionsProperty {
        /**
         * `CfnDeliveryStream.SplunkRetryOptionsProperty.DurationInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-splunkretryoptions.html#cfn-kinesisfirehose-deliverystream-splunkretryoptions-durationinseconds
         * @external
         */
        readonly durationInSeconds?: number;
    }
}
/**
 * A CloudFormation `AWS::KinesisFirehose::DeliveryStream`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kinesisfirehose-deliverystream.html
 * @external
 * @cloudformationResource AWS::KinesisFirehose::DeliveryStream
 */
export declare namespace CfnDeliveryStream {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html
     * @external
     */
    interface VpcConfigurationProperty {
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.RoleARN`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-rolearn
         * @external
         */
        readonly roleArn: string;
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnDeliveryStream.VpcConfigurationProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-vpcconfiguration.html#cfn-kinesisfirehose-deliverystream-vpcconfiguration-subnetids
         * @external
         */
        readonly subnetIds: string[];
    }
}
