"use strict";
/**
 *  Copyright 2021 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
const aws_elasticloadbalancingv2_1 = require("@aws-cdk/aws-elasticloadbalancingv2");
const aws_route53_1 = require("@aws-cdk/aws-route53");
const lib_1 = require("../lib");
const core_2 = require("@aws-solutions-constructs/core");
// Setup
const app = new core_1.App();
const stack = new core_1.Stack(app, core_2.generateIntegStackName(__filename), {
    env: { account: core_1.Aws.ACCOUNT_ID, region: 'us-east-1' },
});
stack.templateOptions.description = 'Integration Test for aws-route53-alb';
const newVpc = defaults.buildVpc(stack, {
    defaultVpcProps: defaults.DefaultPublicPrivateVpcProps(),
    constructVpcProps: {
        enableDnsHostnames: true,
        enableDnsSupport: true,
        cidr: '172.168.0.0/16',
    },
});
const newZone = new aws_route53_1.PublicHostedZone(stack, 'new-zone', {
    zoneName: 'www.test-example.com',
});
const existingAlb = new aws_elasticloadbalancingv2_1.ApplicationLoadBalancer(stack, 'test-alb', {
    vpc: newVpc,
});
defaults.addCfnSuppressRules(existingAlb, [{ id: 'W52', reason: 'Test ALB only.' }]);
// Definitions
const props = {
    publicApi: true,
    existingHostedZoneInterface: newZone,
    existingVpc: newVpc,
    existingLoadBalancerObj: existingAlb,
};
const testConstruct = new lib_1.Route53ToAlb(stack, 'public-api-stack', props);
const newSecurityGroup = testConstruct.loadBalancer.connections.securityGroups[0].node.defaultChild;
defaults.addCfnSuppressRules(newSecurityGroup, [{ id: 'W29', reason: 'CDK created rule that blocks all traffic.' }]);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,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