"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TargetApplication = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const application_1 = require("./application");
/**
  * Contains static factory methods with which you can build the input
  * needed for application associator to work
  */
class TargetApplication {
    /**
      * Factory method to build the input using the provided
      * application ARN.
      */
    static existingApplicationFromArn(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_ExistingTargetApplicationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.existingApplicationFromArn);
            }
            throw error;
        }
        return new ExistingTargetApplication(options);
    }
    /**
      * Factory method to build the input using the provided
      * application name and stack props.
      */
    static createApplicationStack(options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_CreateTargetApplicationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.createApplicationStack);
            }
            throw error;
        }
        return new CreateTargetApplication(options);
    }
}
exports.TargetApplication = TargetApplication;
_a = JSII_RTTI_SYMBOL_1;
TargetApplication[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.TargetApplication", version: "2.63.2-alpha.0" };
/**
  * Class which constructs the input from provided application name and stack props.
  * With this input, the construct will create the Application.
  */
class CreateTargetApplication extends TargetApplication {
    constructor(applicationOptions) {
        super();
        this.applicationOptions = applicationOptions;
    }
    bind(scope) {
        const stackId = this.applicationOptions.stackId ?? 'ApplicationAssociatorStack';
        this.applicationOptions.description =
            this.applicationOptions.description || 'Stack to create AppRegistry application';
        this.applicationOptions.env =
            this.applicationOptions.env || { account: process.env.CDK_DEFAULT_ACCOUNT, region: process.env.CDK_DEFAULT_REGION };
        const applicationStack = new cdk.Stack(scope, stackId, this.applicationOptions);
        const appRegApplication = new application_1.Application(applicationStack, 'DefaultCdkApplication', {
            applicationName: this.applicationOptions.applicationName,
            description: this.applicationOptions.applicationDescription || 'Application containing stacks deployed via CDK.',
        });
        cdk.Tags.of(appRegApplication).add('managedBy', 'CDK_Application_Associator');
        return {
            application: appRegApplication,
        };
    }
}
/**
  * Class which constructs the input from provided Application ARN.
  */
class ExistingTargetApplication extends TargetApplication {
    constructor(applicationOptions) {
        super();
        this.applicationOptions = applicationOptions;
    }
    bind(scope) {
        const stackId = this.applicationOptions.stackId ?? 'ApplicationAssociatorStack';
        const applicationStack = new cdk.Stack(scope, stackId, this.applicationOptions);
        const appRegApplication = application_1.Application.fromApplicationArn(applicationStack, 'ExistingApplication', this.applicationOptions.applicationArnValue);
        return {
            application: appRegApplication,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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