import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IApplication } from './application';
/**
  * Properties used to define targetapplication.
  */
export interface TargetApplicationCommonOptions extends cdk.StackProps {
    /**
      * Stack ID in which application will be created or imported. The id of a stack is also the identifier that you use to
      * refer to it in the [AWS CDK Toolkit](https://docs.aws.amazon.com/cdk/v2/guide/cli.html).
      *
      * @default - ApplicationAssociatorStack
      */
    readonly stackId?: string;
}
/**
  * Properties used to define New TargetApplication.
  */
export interface CreateTargetApplicationOptions extends TargetApplicationCommonOptions {
    /**
      * Enforces a particular physical application name.
      */
    readonly applicationName: string;
    /**
      * Application description.
      *
      * @default - Application containing stacks deployed via CDK.
      */
    readonly applicationDescription?: string;
}
/**
  * Properties used to define Existing TargetApplication.
  */
export interface ExistingTargetApplicationOptions extends TargetApplicationCommonOptions {
    /**
      * Enforces a particular application arn.
      */
    readonly applicationArnValue: string;
}
/**
  * Contains static factory methods with which you can build the input
  * needed for application associator to work
  */
export declare abstract class TargetApplication {
    /**
      * Factory method to build the input using the provided
      * application ARN.
      */
    static existingApplicationFromArn(options: ExistingTargetApplicationOptions): TargetApplication;
    /**
      * Factory method to build the input using the provided
      * application name and stack props.
      */
    static createApplicationStack(options: CreateTargetApplicationOptions): TargetApplication;
    /**
      * Called when the ApplicationAssociator is initialized
      */
    abstract bind(scope: Construct): BindTargetApplicationResult;
}
/**
  * Properties for Service Catalog AppRegistry Application Associator to work with
  */
export interface BindTargetApplicationResult {
    /**
     * Created or imported application.
     */
    readonly application: IApplication;
}
