"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationAssociator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const stack_associator_1 = require("./aspects/stack-associator");
/**
 * An AppRegistry construct to automatically create an application with the given name and description.
 *
 * The application name must be unique at the account level per region and it's immutable.
 * This construct will automatically associate all stacks in the given scope, however
 * in case of a `Pipeline` stack, stage underneath the pipeline will not automatically be associated and
 * needs to be associated separately.
 *
 * If cross account stack is detected, then this construct will automatically share the application to consumer accounts.
 * Cross account feature will only work for non environment agnostic stacks.
 */
class ApplicationAssociator extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.associatedStages = new Set();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_servicecatalogappregistry_alpha_ApplicationAssociatorProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ApplicationAssociator);
            }
            throw error;
        }
        if (props.applications.length != 1) {
            throw new Error('Please pass exactly 1 instance of TargetApplication.createApplicationStack() or TargetApplication.existingApplicationFromArn() into the "applications" property');
        }
        const targetApplication = props.applications[0];
        this.application = targetApplication.bind(scope).application;
        cdk.Aspects.of(scope).add(new stack_associator_1.CheckedStageStackAssociator(this));
    }
    /**
     * Associate this application with the given stage.
     *
     */
    associateStage(stage) {
        this.associatedStages.add(stage);
        cdk.Aspects.of(stage).add(new stack_associator_1.CheckedStageStackAssociator(this));
        return stage;
    }
    /**
     * Validates if a stage is already associated to the application.
     *
     */
    isStageAssociated(stage) {
        return this.associatedStages.has(stage);
    }
    /**
     * Get the AppRegistry application.
     *
     */
    appRegistryApplication() {
        return this.application;
    }
}
exports.ApplicationAssociator = ApplicationAssociator;
_a = JSII_RTTI_SYMBOL_1;
ApplicationAssociator[_a] = { fqn: "@aws-cdk/aws-servicecatalogappregistry-alpha.ApplicationAssociator", version: "2.63.2-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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