import * as cdk from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { IApplication } from './application';
import { TargetApplication } from './target-application';
/**
 * Properties for Service Catalog AppRegistry Application Associator
 */
export interface ApplicationAssociatorProps {
    /**
     * Application associator properties.
     *
     * @default - Empty array.
     */
    readonly applications: TargetApplication[];
}
/**
 * An AppRegistry construct to automatically create an application with the given name and description.
 *
 * The application name must be unique at the account level per region and it's immutable.
 * This construct will automatically associate all stacks in the given scope, however
 * in case of a `Pipeline` stack, stage underneath the pipeline will not automatically be associated and
 * needs to be associated separately.
 *
 * If cross account stack is detected, then this construct will automatically share the application to consumer accounts.
 * Cross account feature will only work for non environment agnostic stacks.
 */
export declare class ApplicationAssociator extends Construct {
    /**
     * Created or imported application.
     */
    private readonly application;
    private readonly associatedStages;
    constructor(scope: cdk.App, id: string, props: ApplicationAssociatorProps);
    /**
     * Associate this application with the given stage.
     *
     */
    associateStage(stage: cdk.Stage): cdk.Stage;
    /**
     * Validates if a stage is already associated to the application.
     *
     */
    isStageAssociated(stage: cdk.Stage): boolean;
    /**
     * Get the AppRegistry application.
     *
     */
    appRegistryApplication(): IApplication;
}
