import * as cdk from '@aws-cdk/core';
/**
 * Properties for defining a `AWS::MediaStore::Container`
 *
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 */
export interface CfnContainerProps {
    /**
     * `AWS::MediaStore::Container.ContainerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername
     */
    readonly containerName: string;
    /**
     * `AWS::MediaStore::Container.AccessLoggingEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled
     */
    readonly accessLoggingEnabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::MediaStore::Container.CorsPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy
     */
    readonly corsPolicy?: Array<CfnContainer.CorsRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::MediaStore::Container.LifecyclePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy
     */
    readonly lifecyclePolicy?: string;
    /**
     * `AWS::MediaStore::Container.MetricPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy
     */
    readonly metricPolicy?: CfnContainer.MetricPolicyProperty | cdk.IResolvable;
    /**
     * `AWS::MediaStore::Container.Policy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy
     */
    readonly policy?: string;
    /**
     * `AWS::MediaStore::Container.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::MediaStore::Container`
 *
 * @cloudformationResource AWS::MediaStore::Container
 * @stability external
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html
 */
export declare class CfnContainer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::MediaStore::Container";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @experimental
     */
    static fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cdk.FromCloudFormationOptions): CfnContainer;
    /**
     * @cloudformationAttribute Endpoint
     */
    readonly attrEndpoint: string;
    /**
     * `AWS::MediaStore::Container.ContainerName`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-containername
     */
    containerName: string;
    /**
     * `AWS::MediaStore::Container.AccessLoggingEnabled`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-accessloggingenabled
     */
    accessLoggingEnabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaStore::Container.CorsPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-corspolicy
     */
    corsPolicy: Array<CfnContainer.CorsRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaStore::Container.LifecyclePolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-lifecyclepolicy
     */
    lifecyclePolicy: string | undefined;
    /**
     * `AWS::MediaStore::Container.MetricPolicy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-metricpolicy
     */
    metricPolicy: CfnContainer.MetricPolicyProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::MediaStore::Container.Policy`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-policy
     */
    policy: string | undefined;
    /**
     * `AWS::MediaStore::Container.Tags`
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mediastore-container.html#cfn-mediastore-container-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::MediaStore::Container`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnContainerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     * @stability experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnContainer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html
     */
    interface CorsRuleProperty {
        /**
         * `CfnContainer.CorsRuleProperty.AllowedHeaders`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedheaders
         */
        readonly allowedHeaders?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.AllowedMethods`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedmethods
         */
        readonly allowedMethods?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.AllowedOrigins`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-allowedorigins
         */
        readonly allowedOrigins?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.ExposeHeaders`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-exposeheaders
         */
        readonly exposeHeaders?: string[];
        /**
         * `CfnContainer.CorsRuleProperty.MaxAgeSeconds`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-corsrule.html#cfn-mediastore-container-corsrule-maxageseconds
         */
        readonly maxAgeSeconds?: number;
    }
}
export declare namespace CfnContainer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html
     */
    interface MetricPolicyProperty {
        /**
         * `CfnContainer.MetricPolicyProperty.ContainerLevelMetrics`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-containerlevelmetrics
         */
        readonly containerLevelMetrics: string;
        /**
         * `CfnContainer.MetricPolicyProperty.MetricPolicyRules`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicy.html#cfn-mediastore-container-metricpolicy-metricpolicyrules
         */
        readonly metricPolicyRules?: Array<CfnContainer.MetricPolicyRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnContainer {
    /**
     * @stability external
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html
     */
    interface MetricPolicyRuleProperty {
        /**
         * `CfnContainer.MetricPolicyRuleProperty.ObjectGroup`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroup
         */
        readonly objectGroup: string;
        /**
         * `CfnContainer.MetricPolicyRuleProperty.ObjectGroupName`
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mediastore-container-metricpolicyrule.html#cfn-mediastore-container-metricpolicyrule-objectgroupname
         */
        readonly objectGroupName: string;
    }
}
