# type: ignore
# pylint: skip-file
"""init

Revision ID: dc8f1df07766
Revises: 
Create Date: 2020-08-04 08:12:31.613299

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "dc8f1df07766"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "job",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("description", sa.Text(), nullable=False),
        sa.Column("graph_spec", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("query_fields", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.Column("category", sa.Enum("gov", "sec", name="category"), nullable=False),
        sa.Column(
            "severity", sa.Enum("debug", "info", "warn", "error", name="severity"), nullable=False
        ),
        sa.Column("query", sa.Text(), nullable=False),
        sa.Column("max_graph_age_sec", sa.Integer(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("active", sa.Boolean(), server_default="false", nullable=False),
        sa.Column("result_expiration_sec", sa.Integer(), nullable=False),
        sa.Column("max_result_age_sec", sa.Integer(), nullable=False),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("name", "created", name="job_name_created_key"),
    )
    op.create_index(
        "job_name_active_key",
        "job",
        ["name", "active"],
        unique=True,
        postgresql_where=sa.text("active"),
    )
    op.create_table(
        "result_set",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("result_set_id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("job_id", sa.Integer(), nullable=False),
        sa.Column("created", sa.DateTime(), nullable=False),
        sa.Column("graph_spec", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.ForeignKeyConstraint(["job_id"], ["job.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("result_set_id"),
    )
    op.create_index("result_set_created_idx", "result_set", ["created"], unique=False)
    op.create_index("result_set_job_id_idx", "result_set", ["job_id"], unique=False)
    op.create_table(
        "result",
        sa.Column("id", sa.Integer(), nullable=False),
        sa.Column("result_set_id", sa.Integer(), nullable=False),
        sa.Column("account_id", sa.Text(), nullable=False),
        sa.Column("result_id", postgresql.UUID(as_uuid=True), nullable=False),
        sa.Column("result", postgresql.JSONB(astext_type=sa.Text()), nullable=False),
        sa.ForeignKeyConstraint(["result_set_id"], ["result_set.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("id"),
        sa.UniqueConstraint("result_id"),
    )
    op.create_index("result_account_id_idx", "result", ["account_id"], unique=False)
    op.create_index("result_result_set_id_idx", "result", ["result_set_id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("result_result_set_id_idx", table_name="result")
    op.drop_index("result_account_id_idx", table_name="result")
    op.drop_table("result")
    op.drop_index("result_set_job_id_idx", table_name="result_set")
    op.drop_index("result_set_created_idx", table_name="result_set")
    op.drop_table("result_set")
    op.drop_index("job_name_active_key", table_name="job")
    op.drop_table("job")
    # ### end Alembic commands ###
