import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 */
export interface CfnDetectorModelProps {
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition
     * @external
     */
    readonly detectorModelDefinition?: CfnDetectorModel.DetectorModelDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription
     * @external
     */
    readonly detectorModelDescription?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname
     * @external
     */
    readonly detectorModelName?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.EvaluationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod
     * @external
     */
    readonly evaluationMethod?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.Key`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key
     * @external
     */
    readonly key?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn
     * @external
     */
    readonly roleArn?: string;
    /**
     * `AWS::IoTEvents::DetectorModel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare class CfnDetectorModel extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTEvents::DetectorModel";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDetectorModel;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldefinition
     * @external
     */
    detectorModelDefinition: CfnDetectorModel.DetectorModelDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodeldescription
     * @external
     */
    detectorModelDescription: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.DetectorModelName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-detectormodelname
     * @external
     */
    detectorModelName: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.EvaluationMethod`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-evaluationmethod
     * @external
     */
    evaluationMethod: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.Key`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-key
     * @external
     */
    key: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.RoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-rolearn
     * @external
     */
    roleArn: string | undefined;
    /**
     * `AWS::IoTEvents::DetectorModel.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html#cfn-iotevents-detectormodel-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTEvents::DetectorModel`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDetectorModelProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html
     * @external
     */
    interface ActionProperty {
        /**
         * `CfnDetectorModel.ActionProperty.ClearTimer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-cleartimer
         * @external
         */
        readonly clearTimer?: CfnDetectorModel.ClearTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.DynamoDB`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodb
         * @external
         */
        readonly dynamoDb?: CfnDetectorModel.DynamoDBProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.DynamoDBv2`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-dynamodbv2
         * @external
         */
        readonly dynamoDBv2?: CfnDetectorModel.DynamoDBv2Property | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Firehose`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-firehose
         * @external
         */
        readonly firehose?: CfnDetectorModel.FirehoseProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotevents
         * @external
         */
        readonly iotEvents?: CfnDetectorModel.IotEventsProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotSiteWise`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iotsitewise
         * @external
         */
        readonly iotSiteWise?: CfnDetectorModel.IotSiteWiseProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.IotTopicPublish`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-iottopicpublish
         * @external
         */
        readonly iotTopicPublish?: CfnDetectorModel.IotTopicPublishProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Lambda`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-lambda
         * @external
         */
        readonly lambda?: CfnDetectorModel.LambdaProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.ResetTimer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-resettimer
         * @external
         */
        readonly resetTimer?: CfnDetectorModel.ResetTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.SetTimer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-settimer
         * @external
         */
        readonly setTimer?: CfnDetectorModel.SetTimerProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.SetVariable`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-setvariable
         * @external
         */
        readonly setVariable?: CfnDetectorModel.SetVariableProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Sns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sns
         * @external
         */
        readonly sns?: CfnDetectorModel.SnsProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.ActionProperty.Sqs`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-action.html#cfn-iotevents-detectormodel-action-sqs
         * @external
         */
        readonly sqs?: CfnDetectorModel.SqsProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html
     * @external
     */
    interface AssetPropertyTimestampProperty {
        /**
         * `CfnDetectorModel.AssetPropertyTimestampProperty.OffsetInNanos`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-offsetinnanos
         * @external
         */
        readonly offsetInNanos?: string;
        /**
         * `CfnDetectorModel.AssetPropertyTimestampProperty.TimeInSeconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertytimestamp.html#cfn-iotevents-detectormodel-assetpropertytimestamp-timeinseconds
         * @external
         */
        readonly timeInSeconds?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html
     * @external
     */
    interface AssetPropertyValueProperty {
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Quality`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-quality
         * @external
         */
        readonly quality?: string;
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Timestamp`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-timestamp
         * @external
         */
        readonly timestamp?: CfnDetectorModel.AssetPropertyTimestampProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.AssetPropertyValueProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvalue.html#cfn-iotevents-detectormodel-assetpropertyvalue-value
         * @external
         */
        readonly value?: CfnDetectorModel.AssetPropertyVariantProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html
     * @external
     */
    interface AssetPropertyVariantProperty {
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.BooleanValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-booleanvalue
         * @external
         */
        readonly booleanValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.DoubleValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-doublevalue
         * @external
         */
        readonly doubleValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.IntegerValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-integervalue
         * @external
         */
        readonly integerValue?: string;
        /**
         * `CfnDetectorModel.AssetPropertyVariantProperty.StringValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-assetpropertyvariant.html#cfn-iotevents-detectormodel-assetpropertyvariant-stringvalue
         * @external
         */
        readonly stringValue?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html
     * @external
     */
    interface ClearTimerProperty {
        /**
         * `CfnDetectorModel.ClearTimerProperty.TimerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-cleartimer.html#cfn-iotevents-detectormodel-cleartimer-timername
         * @external
         */
        readonly timerName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html
     * @external
     */
    interface DetectorModelDefinitionProperty {
        /**
         * `CfnDetectorModel.DetectorModelDefinitionProperty.InitialStateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-initialstatename
         * @external
         */
        readonly initialStateName?: string;
        /**
         * `CfnDetectorModel.DetectorModelDefinitionProperty.States`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-detectormodeldefinition.html#cfn-iotevents-detectormodel-detectormodeldefinition-states
         * @external
         */
        readonly states?: Array<CfnDetectorModel.StateProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html
     * @external
     */
    interface DynamoDBProperty {
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyfield
         * @external
         */
        readonly hashKeyField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeytype
         * @external
         */
        readonly hashKeyType?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.HashKeyValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-hashkeyvalue
         * @external
         */
        readonly hashKeyValue?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.Operation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-operation
         * @external
         */
        readonly operation?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.DynamoDBProperty.PayloadField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-payloadfield
         * @external
         */
        readonly payloadField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyField`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyfield
         * @external
         */
        readonly rangeKeyField?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeytype
         * @external
         */
        readonly rangeKeyType?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.RangeKeyValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-rangekeyvalue
         * @external
         */
        readonly rangeKeyValue?: string;
        /**
         * `CfnDetectorModel.DynamoDBProperty.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodb.html#cfn-iotevents-detectormodel-dynamodb-tablename
         * @external
         */
        readonly tableName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html
     * @external
     */
    interface DynamoDBv2Property {
        /**
         * `CfnDetectorModel.DynamoDBv2Property.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.DynamoDBv2Property.TableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-dynamodbv2.html#cfn-iotevents-detectormodel-dynamodbv2-tablename
         * @external
         */
        readonly tableName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html
     * @external
     */
    interface EventProperty {
        /**
         * `CfnDetectorModel.EventProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-actions
         * @external
         */
        readonly actions?: Array<CfnDetectorModel.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.EventProperty.Condition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-condition
         * @external
         */
        readonly condition?: string;
        /**
         * `CfnDetectorModel.EventProperty.EventName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-event.html#cfn-iotevents-detectormodel-event-eventname
         * @external
         */
        readonly eventName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html
     * @external
     */
    interface FirehoseProperty {
        /**
         * `CfnDetectorModel.FirehoseProperty.DeliveryStreamName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-deliverystreamname
         * @external
         */
        readonly deliveryStreamName?: string;
        /**
         * `CfnDetectorModel.FirehoseProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.FirehoseProperty.Separator`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-firehose.html#cfn-iotevents-detectormodel-firehose-separator
         * @external
         */
        readonly separator?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html
     * @external
     */
    interface IotEventsProperty {
        /**
         * `CfnDetectorModel.IotEventsProperty.InputName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-inputname
         * @external
         */
        readonly inputName?: string;
        /**
         * `CfnDetectorModel.IotEventsProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotevents.html#cfn-iotevents-detectormodel-iotevents-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html
     * @external
     */
    interface IotSiteWiseProperty {
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.AssetId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-assetid
         * @external
         */
        readonly assetId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.EntryId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-entryid
         * @external
         */
        readonly entryId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyAlias`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyalias
         * @external
         */
        readonly propertyAlias?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyid
         * @external
         */
        readonly propertyId?: string;
        /**
         * `CfnDetectorModel.IotSiteWiseProperty.PropertyValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iotsitewise.html#cfn-iotevents-detectormodel-iotsitewise-propertyvalue
         * @external
         */
        readonly propertyValue?: CfnDetectorModel.AssetPropertyValueProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html
     * @external
     */
    interface IotTopicPublishProperty {
        /**
         * `CfnDetectorModel.IotTopicPublishProperty.MqttTopic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-mqtttopic
         * @external
         */
        readonly mqttTopic?: string;
        /**
         * `CfnDetectorModel.IotTopicPublishProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-iottopicpublish.html#cfn-iotevents-detectormodel-iottopicpublish-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html
     * @external
     */
    interface LambdaProperty {
        /**
         * `CfnDetectorModel.LambdaProperty.FunctionArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-functionarn
         * @external
         */
        readonly functionArn?: string;
        /**
         * `CfnDetectorModel.LambdaProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-lambda.html#cfn-iotevents-detectormodel-lambda-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html
     * @external
     */
    interface OnEnterProperty {
        /**
         * `CfnDetectorModel.OnEnterProperty.Events`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onenter.html#cfn-iotevents-detectormodel-onenter-events
         * @external
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html
     * @external
     */
    interface OnExitProperty {
        /**
         * `CfnDetectorModel.OnExitProperty.Events`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-onexit.html#cfn-iotevents-detectormodel-onexit-events
         * @external
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html
     * @external
     */
    interface OnInputProperty {
        /**
         * `CfnDetectorModel.OnInputProperty.Events`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-events
         * @external
         */
        readonly events?: Array<CfnDetectorModel.EventProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.OnInputProperty.TransitionEvents`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-oninput.html#cfn-iotevents-detectormodel-oninput-transitionevents
         * @external
         */
        readonly transitionEvents?: Array<CfnDetectorModel.TransitionEventProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html
     * @external
     */
    interface PayloadProperty {
        /**
         * `CfnDetectorModel.PayloadProperty.ContentExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-contentexpression
         * @external
         */
        readonly contentExpression?: string;
        /**
         * `CfnDetectorModel.PayloadProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-payload.html#cfn-iotevents-detectormodel-payload-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html
     * @external
     */
    interface ResetTimerProperty {
        /**
         * `CfnDetectorModel.ResetTimerProperty.TimerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-resettimer.html#cfn-iotevents-detectormodel-resettimer-timername
         * @external
         */
        readonly timerName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html
     * @external
     */
    interface SetTimerProperty {
        /**
         * `CfnDetectorModel.SetTimerProperty.DurationExpression`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-durationexpression
         * @external
         */
        readonly durationExpression?: string;
        /**
         * `CfnDetectorModel.SetTimerProperty.Seconds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-seconds
         * @external
         */
        readonly seconds?: number;
        /**
         * `CfnDetectorModel.SetTimerProperty.TimerName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-settimer.html#cfn-iotevents-detectormodel-settimer-timername
         * @external
         */
        readonly timerName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html
     * @external
     */
    interface SetVariableProperty {
        /**
         * `CfnDetectorModel.SetVariableProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-value
         * @external
         */
        readonly value?: string;
        /**
         * `CfnDetectorModel.SetVariableProperty.VariableName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-setvariable.html#cfn-iotevents-detectormodel-setvariable-variablename
         * @external
         */
        readonly variableName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html
     * @external
     */
    interface SnsProperty {
        /**
         * `CfnDetectorModel.SnsProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.SnsProperty.TargetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sns.html#cfn-iotevents-detectormodel-sns-targetarn
         * @external
         */
        readonly targetArn?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html
     * @external
     */
    interface SqsProperty {
        /**
         * `CfnDetectorModel.SqsProperty.Payload`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-payload
         * @external
         */
        readonly payload?: CfnDetectorModel.PayloadProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.SqsProperty.QueueUrl`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-queueurl
         * @external
         */
        readonly queueUrl?: string;
        /**
         * `CfnDetectorModel.SqsProperty.UseBase64`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-sqs.html#cfn-iotevents-detectormodel-sqs-usebase64
         * @external
         */
        readonly useBase64?: boolean | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html
     * @external
     */
    interface StateProperty {
        /**
         * `CfnDetectorModel.StateProperty.OnEnter`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onenter
         * @external
         */
        readonly onEnter?: CfnDetectorModel.OnEnterProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.OnExit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-onexit
         * @external
         */
        readonly onExit?: CfnDetectorModel.OnExitProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.OnInput`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-oninput
         * @external
         */
        readonly onInput?: CfnDetectorModel.OnInputProperty | cdk.IResolvable;
        /**
         * `CfnDetectorModel.StateProperty.StateName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-state.html#cfn-iotevents-detectormodel-state-statename
         * @external
         */
        readonly stateName?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::DetectorModel`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-detectormodel.html
 * @external
 * @cloudformationResource AWS::IoTEvents::DetectorModel
 */
export declare namespace CfnDetectorModel {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html
     * @external
     */
    interface TransitionEventProperty {
        /**
         * `CfnDetectorModel.TransitionEventProperty.Actions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-actions
         * @external
         */
        readonly actions?: Array<CfnDetectorModel.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnDetectorModel.TransitionEventProperty.Condition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-condition
         * @external
         */
        readonly condition?: string;
        /**
         * `CfnDetectorModel.TransitionEventProperty.EventName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-eventname
         * @external
         */
        readonly eventName?: string;
        /**
         * `CfnDetectorModel.TransitionEventProperty.NextState`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-detectormodel-transitionevent.html#cfn-iotevents-detectormodel-transitionevent-nextstate
         * @external
         */
        readonly nextState?: string;
    }
}
/**
 * Properties for defining a `AWS::IoTEvents::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 * @external
 */
export interface CfnInputProps {
    /**
     * `AWS::IoTEvents::Input.InputDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition
     * @external
     */
    readonly inputDefinition?: CfnInput.InputDefinitionProperty | cdk.IResolvable;
    /**
     * `AWS::IoTEvents::Input.InputDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription
     * @external
     */
    readonly inputDescription?: string;
    /**
     * `AWS::IoTEvents::Input.InputName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname
     * @external
     */
    readonly inputName?: string;
    /**
     * `AWS::IoTEvents::Input.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 * @external
 * @cloudformationResource AWS::IoTEvents::Input
 */
export declare class CfnInput extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTEvents::Input";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnInput;
    /**
     * `AWS::IoTEvents::Input.InputDefinition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdefinition
     * @external
     */
    inputDefinition: CfnInput.InputDefinitionProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTEvents::Input.InputDescription`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputdescription
     * @external
     */
    inputDescription: string | undefined;
    /**
     * `AWS::IoTEvents::Input.InputName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-inputname
     * @external
     */
    inputName: string | undefined;
    /**
     * `AWS::IoTEvents::Input.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html#cfn-iotevents-input-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTEvents::Input`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnInputProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 * @external
 * @cloudformationResource AWS::IoTEvents::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html
     * @external
     */
    interface AttributeProperty {
        /**
         * `CfnInput.AttributeProperty.JsonPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-attribute.html#cfn-iotevents-input-attribute-jsonpath
         * @external
         */
        readonly jsonPath?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTEvents::Input`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotevents-input.html
 * @external
 * @cloudformationResource AWS::IoTEvents::Input
 */
export declare namespace CfnInput {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html
     * @external
     */
    interface InputDefinitionProperty {
        /**
         * `CfnInput.InputDefinitionProperty.Attributes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotevents-input-inputdefinition.html#cfn-iotevents-input-inputdefinition-attributes
         * @external
         */
        readonly attributes?: Array<CfnInput.AttributeProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
