"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationProduct = exports.Product = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const validation_1 = require("./private/validation");
const aws_servicecatalog_1 = require("aws-cdk-lib/aws-servicecatalog");
class ProductBase extends aws_cdk_lib_1.Resource {
}
/**
 * (experimental) Abstract class for Service Catalog Product.
 *
 * @experimental
 */
class Product extends ProductBase {
    /**
     * (experimental) Creates a Product construct that represents an external product.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param productArn Product Arn.
     * @experimental
     */
    static fromProductArn(scope, id, productArn) {
        const arn = aws_cdk_lib_1.Stack.of(scope).splitArn(productArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
        const productId = arn.resourceName;
        if (!productId) {
            throw new Error('Missing required Portfolio ID from Portfolio ARN: ' + productArn);
        }
        return new class extends ProductBase {
            constructor() {
                super(...arguments);
                this.productId = productId;
                this.productArn = productArn;
            }
        }(scope, id);
    }
}
exports.Product = Product;
_a = JSII_RTTI_SYMBOL_1;
Product[_a] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.Product", version: "2.0.0-alpha.2" };
/**
 * (experimental) A Service Catalog Cloudformation Product.
 *
 * @experimental
 */
class CloudFormationProduct extends Product {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.validateProductProps(props);
        const product = new aws_servicecatalog_1.CfnCloudFormationProduct(this, 'Resource', {
            acceptLanguage: props.messageLanguage,
            description: props.description,
            distributor: props.distributor,
            name: props.productName,
            owner: props.owner,
            provisioningArtifactParameters: this.renderProvisioningArtifacts(props),
            replaceProvisioningArtifacts: props.replaceProductVersionIds,
            supportDescription: props.supportDescription,
            supportEmail: props.supportEmail,
            supportUrl: props.supportUrl,
        });
        this.productArn = aws_cdk_lib_1.Stack.of(this).formatArn({
            service: 'catalog',
            resource: 'product',
            resourceName: product.ref,
        });
        this.productId = product.ref;
    }
    renderProvisioningArtifacts(props) {
        return props.productVersions.map(productVersion => {
            const template = productVersion.cloudFormationTemplate.bind(this);
            validation_1.InputValidator.validateUrl(this.node.path, 'provisioning template url', template.httpUrl);
            return {
                name: productVersion.productVersionName,
                description: productVersion.description,
                disableTemplateValidation: productVersion.validateTemplate === false ? true : false,
                info: {
                    LoadTemplateFromURL: template.httpUrl,
                },
            };
        });
    }
    ;
    validateProductProps(props) {
        validation_1.InputValidator.validateLength(this.node.path, 'product product name', 1, 100, props.productName);
        validation_1.InputValidator.validateLength(this.node.path, 'product owner', 1, 8191, props.owner);
        validation_1.InputValidator.validateLength(this.node.path, 'product description', 0, 8191, props.description);
        validation_1.InputValidator.validateLength(this.node.path, 'product distributor', 0, 8191, props.distributor);
        validation_1.InputValidator.validateEmail(this.node.path, 'support email', props.supportEmail);
        validation_1.InputValidator.validateUrl(this.node.path, 'support url', props.supportUrl);
        validation_1.InputValidator.validateLength(this.node.path, 'support description', 0, 8191, props.supportDescription);
        if (props.productVersions.length == 0) {
            throw new Error(`Invalid product versions for resource ${this.node.path}, must contain at least 1 product version`);
        }
        props.productVersions.forEach(productVersion => {
            validation_1.InputValidator.validateLength(this.node.path, 'provisioning artifact name', 0, 100, productVersion.productVersionName);
            validation_1.InputValidator.validateLength(this.node.path, 'provisioning artifact description', 0, 8191, productVersion.description);
        });
    }
}
exports.CloudFormationProduct = CloudFormationProduct;
_b = JSII_RTTI_SYMBOL_1;
CloudFormationProduct[_b] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.CloudFormationProduct", version: "2.0.0-alpha.2" };
//# sourceMappingURL=data:application/json;base64,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