"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFormationTemplate = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const s3_assets = require("aws-cdk-lib/aws-s3-assets");
const util_1 = require("./private/util");
/**
 * (experimental) Represents the Product Provisioning Artifact Template.
 *
 * @experimental
 */
class CloudFormationTemplate {
    /**
     * (experimental) Template from URL.
     *
     * @param url The url that points to the provisioning artifacts template.
     * @experimental
     */
    static fromUrl(url) {
        return new CloudFormationUrlTemplate(url);
    }
    /**
     * (experimental) Loads the provisioning artifacts template from a local disk path.
     *
     * @param path A file containing the provisioning artifacts.
     * @experimental
     */
    static fromAsset(path, options) {
        return new CloudFormationAssetTemplate(path, options);
    }
}
exports.CloudFormationTemplate = CloudFormationTemplate;
_a = JSII_RTTI_SYMBOL_1;
CloudFormationTemplate[_a] = { fqn: "@aws-cdk/aws-servicecatalog-alpha.CloudFormationTemplate", version: "2.0.0-alpha.2" };
/**
 * Template code from a Url.
 */
class CloudFormationUrlTemplate extends CloudFormationTemplate {
    constructor(url) {
        super();
        this.url = url;
    }
    bind(_scope) {
        return {
            httpUrl: this.url,
        };
    }
}
/**
 * Template from a local file.
 */
class CloudFormationAssetTemplate extends CloudFormationTemplate {
    /**
     * @param path The path to the asset file.
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
    }
    bind(scope) {
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new s3_assets.Asset(scope, `Template${util_1.hashValues(this.path)}`, {
                path: this.path,
                ...this.options,
            });
        }
        return {
            httpUrl: this.asset.httpUrl,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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