Thank you for using *archetypal* and for considering contributing to it!

#### For errors in the code:

  - read the error message and [documentation](https://archetypal.readthedocs.io/);
  - search through the [open issues](https://github.com/samuelduchesne/archetypal/issues?q=is%3Aopen+is%3Aissue) and [closed issues](https://github.com/samuelduchesne/archetypal/issues?q=is%3Aissue+is%3Aclosed) first;
  - if the problem is with a dependency of this project, open an issue on the dependency's repo;
  - if the problem is with *archetypal* and you can fix it simply, please submit a [PR](https://github.com/samuelduchesne/archetypal/pulls);
  - if the problem persists, please open an issue in the [issue tracker](https://github.com/samuelduchesne/archetypal/issues) including a minimal working example to reproduce the problem.

#### If you have a feature proposal or want to contribute

  - post your proposal on the [issue tracker](https://github.com/samuelduchesne/archetypal/issues) so we can review it together (some proposals may not be a good fit for the project);
  - fork the repo, make your change (adhering to archetypal's existing coding format, commenting, and docstring styles);
    [test it](https://github.com/samuelduchesne/archetypal/tree/main/tests);
  - format your code using [black](https://black.readthedocs.io/en/stable/) and submit a [PR](https://github.com/samuelduchesne/archetypal/pulls);
  - respond to code review.
