"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const stepfunctions = require("../lib");
describe('Custom State', () => {
    test('maintains the state Json provided during construction', () => {
        // GIVEN
        const stack = new cdk.Stack();
        const stateJson = {
            Type: 'Task',
            Resource: 'arn:aws:states:::dynamodb:putItem',
            Parameters: {
                TableName: 'MyTable',
                Item: {
                    id: {
                        S: 'MyEntry',
                    },
                },
            },
            ResultPath: null,
        };
        // WHEN
        const customState = new stepfunctions.CustomState(stack, 'Custom', {
            stateJson,
        });
        // THEN
        expect(customState.toStateJson()).toStrictEqual({
            ...stateJson,
            End: true,
        });
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3VzdG9tLXN0YXRlLnRlc3QuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjdXN0b20tc3RhdGUudGVzdC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBLGdDQUE4QjtBQUM5QixxQ0FBcUM7QUFDckMsd0NBQXdDO0FBRXhDLFFBQVEsQ0FBQyxjQUFjLEVBQUUsR0FBRyxFQUFFO0lBQzVCLElBQUksQ0FBQyx1REFBdUQsRUFBRSxHQUFHLEVBQUU7UUFDakUsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBQzlCLE1BQU0sU0FBUyxHQUFHO1lBQ2hCLElBQUksRUFBRSxNQUFNO1lBQ1osUUFBUSxFQUFFLG1DQUFtQztZQUM3QyxVQUFVLEVBQUU7Z0JBQ1YsU0FBUyxFQUFFLFNBQVM7Z0JBQ3BCLElBQUksRUFBRTtvQkFDSixFQUFFLEVBQUU7d0JBQ0YsQ0FBQyxFQUFFLFNBQVM7cUJBQ2I7aUJBQ0Y7YUFDRjtZQUNELFVBQVUsRUFBRSxJQUFJO1NBQ2pCLENBQUM7UUFFRixPQUFPO1FBQ1AsTUFBTSxXQUFXLEdBQUcsSUFBSSxhQUFhLENBQUMsV0FBVyxDQUFDLEtBQUssRUFBRSxRQUFRLEVBQUU7WUFDakUsU0FBUztTQUNWLENBQUMsQ0FBQztRQUVILE9BQU87UUFDUCxNQUFNLENBQUMsV0FBVyxDQUFDLFdBQVcsRUFBRSxDQUFDLENBQUMsYUFBYSxDQUFDO1lBQzlDLEdBQUcsU0FBUztZQUNaLEdBQUcsRUFBRSxJQUFJO1NBQ1YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAnQGF3cy1jZGsvYXNzZXJ0L2plc3QnO1xuaW1wb3J0ICogYXMgY2RrIGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuaW1wb3J0ICogYXMgc3RlcGZ1bmN0aW9ucyBmcm9tICcuLi9saWInO1xuXG5kZXNjcmliZSgnQ3VzdG9tIFN0YXRlJywgKCkgPT4ge1xuICB0ZXN0KCdtYWludGFpbnMgdGhlIHN0YXRlIEpzb24gcHJvdmlkZWQgZHVyaW5nIGNvbnN0cnVjdGlvbicsICgpID0+IHtcbiAgICAvLyBHSVZFTlxuICAgIGNvbnN0IHN0YWNrID0gbmV3IGNkay5TdGFjaygpO1xuICAgIGNvbnN0IHN0YXRlSnNvbiA9IHtcbiAgICAgIFR5cGU6ICdUYXNrJyxcbiAgICAgIFJlc291cmNlOiAnYXJuOmF3czpzdGF0ZXM6OjpkeW5hbW9kYjpwdXRJdGVtJyxcbiAgICAgIFBhcmFtZXRlcnM6IHtcbiAgICAgICAgVGFibGVOYW1lOiAnTXlUYWJsZScsXG4gICAgICAgIEl0ZW06IHtcbiAgICAgICAgICBpZDoge1xuICAgICAgICAgICAgUzogJ015RW50cnknLFxuICAgICAgICAgIH0sXG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgICAgUmVzdWx0UGF0aDogbnVsbCxcbiAgICB9O1xuXG4gICAgLy8gV0hFTlxuICAgIGNvbnN0IGN1c3RvbVN0YXRlID0gbmV3IHN0ZXBmdW5jdGlvbnMuQ3VzdG9tU3RhdGUoc3RhY2ssICdDdXN0b20nLCB7XG4gICAgICBzdGF0ZUpzb24sXG4gICAgfSk7XG5cbiAgICAvLyBUSEVOXG4gICAgZXhwZWN0KGN1c3RvbVN0YXRlLnRvU3RhdGVKc29uKCkpLnRvU3RyaWN0RXF1YWwoe1xuICAgICAgLi4uc3RhdGVKc29uLFxuICAgICAgRW5kOiB0cnVlLFxuICAgIH0pO1xuICB9KTtcbn0pO1xuIl19