"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserIdentity = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const aws_cognito_identitypool_alpha_1 = require("@aws-cdk/aws-cognito-identitypool-alpha");
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cognito_1 = require("aws-cdk-lib/aws-cognito");
const constructs_1 = require("constructs");
/**
 * Creates an Identity Pool with sane defaults configured.
 */
class UserIdentity extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Unless explicitly stated, created a default Cognito User Pool and Web Client.
        if (!props?.userPool) {
            this.userPool = new aws_cognito_1.UserPool(this, "UserPool", {
                passwordPolicy: {
                    minLength: 8,
                    requireLowercase: true,
                    requireUppercase: true,
                    requireDigits: true,
                    requireSymbols: true,
                },
                mfa: aws_cognito_1.Mfa.REQUIRED,
                accountRecovery: aws_cognito_1.AccountRecovery.EMAIL_ONLY,
                autoVerify: {
                    email: true,
                },
            });
            this.userPool.node.defaultChild.userPoolAddOns = {
                advancedSecurityMode: "ENFORCED",
            };
            const stack = aws_cdk_lib_1.Stack.of(this);
            pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${id}/UserPool/smsRole/Resource`, [
                {
                    id: "AwsSolutions-IAM5",
                    reason: "MFA requires sending a text to a users phone number which cannot be known at deployment time.",
                    appliesTo: ["Resource::*"],
                },
            ]);
            this.userPoolClient = this.userPool.addClient("WebClient", {
                authFlows: {
                    userPassword: true,
                    userSrp: true,
                },
            });
        }
        else {
            this.userPool = props.userPool;
        }
        this.identityPool = new aws_cognito_identitypool_alpha_1.IdentityPool(this, "IdentityPool", {
            ...props?.identityPoolOptions,
            authenticationProviders: {
                ...props?.identityPoolOptions?.authenticationProviders,
                userPools: [
                    ...(props?.identityPoolOptions?.authenticationProviders?.userPools ||
                        []),
                    ...(!props?.userPool
                        ? [
                            new aws_cognito_identitypool_alpha_1.UserPoolAuthenticationProvider({
                                userPool: this.userPool,
                                userPoolClient: this.userPoolClient,
                            }),
                        ]
                        : []),
                ],
            },
        });
    }
}
exports.UserIdentity = UserIdentity;
_a = JSII_RTTI_SYMBOL_1;
UserIdentity[_a] = { fqn: "@aws-prototyping-sdk/identity.UserIdentity", version: "0.11.7" };
//# sourceMappingURL=data:application/json;base64,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