import json
import setuptools

kwargs = json.loads("""
{
    "name": "aws-cdk.aws-certificatemanager",
    "version": "1.32.2",
    "description": "The CDK Construct Library for AWS::CertificateManager",
    "license": "Apache-2.0",
    "url": "https://github.com/aws/aws-cdk",
    "long_description_content_type": "text/markdown",
    "author": "Amazon Web Services",
    "project_urls": {
        "Source": "https://github.com/aws/aws-cdk.git"
    },
    "package_dir": {
        "": "src"
    },
    "packages": [
        "aws_cdk.aws_certificatemanager",
        "aws_cdk.aws_certificatemanager._jsii"
    ],
    "package_data": {
        "aws_cdk.aws_certificatemanager._jsii": [
            "aws-certificatemanager@1.32.2.jsii.tgz"
        ],
        "aws_cdk.aws_certificatemanager": [
            "py.typed"
        ]
    },
    "python_requires": ">=3.6",
    "install_requires": [
        "jsii~=1.1.0",
        "publication>=0.0.3",
        "aws-cdk.aws-cloudformation==1.32.2",
        "aws-cdk.aws-iam==1.32.2",
        "aws-cdk.aws-lambda==1.32.2",
        "aws-cdk.aws-route53==1.32.2",
        "aws-cdk.core==1.32.2",
        "constructs>=2.0.0, <3.0.0"
    ],
    "classifiers": [
        "Intended Audience :: Developers",
        "Operating System :: OS Independent",
        "Programming Language :: JavaScript",
        "Programming Language :: Python :: 3 :: Only",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Typing :: Typed",
        "Development Status :: 5 - Production/Stable",
        "License :: OSI Approved"
    ]
}
""")

with open('README.md') as fp:
    kwargs['long_description'] = fp.read()


setuptools.setup(**kwargs)
