"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Lambda Function as the destination for a log subscription
 */
class LambdaDestination {
    /**  LambdaDestinationOptions */
    constructor(fn, options = {}) {
        this.fn = fn;
        this.options = options;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_destinations_LambdaDestinationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, LambdaDestination);
            }
            throw error;
        }
    }
    bind(scope, logGroup) {
        const arn = logGroup.logGroupArn;
        if (this.options.addPermissions !== false) {
            this.fn.addPermission('CanInvokeLambda', {
                principal: new iam.ServicePrincipal('logs.amazonaws.com'),
                sourceArn: arn,
                // Using SubScription Filter as scope is okay, since every Subscription Filter has only
                // one destination.
                scope,
            });
        }
        return { arn: this.fn.functionArn };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.LambdaDestination", version: "1.194.0" };
//# sourceMappingURL=data:application/json;base64,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