"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Kinesis stream as the destination for a log subscription
 */
class KinesisDestination {
    /**
     * @param stream The Kinesis stream to use as destination
     * @param props The Kinesis Destination properties
     *
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_logs_destinations_KinesisDestinationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, KinesisDestination);
            }
            throw error;
        }
    }
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = this.props.role ?? scope.node.tryFindChild(id) ?? new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
_a = JSII_RTTI_SYMBOL_1;
KinesisDestination[_a] = { fqn: "@aws-cdk/aws-logs-destinations.KinesisDestination", version: "1.194.0" };
//# sourceMappingURL=data:application/json;base64,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