"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const util_1 = require("../lib/util");
test('findUp', () => {
    // Starting at process.cwd()
    expect(util_1.findUp('README.md')).toMatch(/aws-lambda-nodejs$/);
    // Non existing file
    expect(util_1.findUp('non-existing-file.unknown')).toBe(undefined);
    // Starting at a specific path
    expect(util_1.findUp('util.test.ts', path.join(__dirname, 'integ-handlers'))).toMatch(/aws-lambda-nodejs\/test$/);
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidXRpbC50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNkJBQTZCO0FBQzdCLHNDQUFxQztBQUVyQyxJQUFJLENBQUMsUUFBUSxFQUFFLEdBQUcsRUFBRTtJQUNsQiw0QkFBNEI7SUFDNUIsTUFBTSxDQUFDLGFBQU0sQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDO0lBRTFELG9CQUFvQjtJQUNwQixNQUFNLENBQUMsYUFBTSxDQUFDLDJCQUEyQixDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUM7SUFFNUQsOEJBQThCO0lBQzlCLE1BQU0sQ0FBQyxhQUFNLENBQUMsY0FBYyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLGdCQUFnQixDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO0FBQzdHLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcGF0aCBmcm9tICdwYXRoJztcbmltcG9ydCB7IGZpbmRVcCB9IGZyb20gJy4uL2xpYi91dGlsJztcblxudGVzdCgnZmluZFVwJywgKCkgPT4ge1xuICAvLyBTdGFydGluZyBhdCBwcm9jZXNzLmN3ZCgpXG4gIGV4cGVjdChmaW5kVXAoJ1JFQURNRS5tZCcpKS50b01hdGNoKC9hd3MtbGFtYmRhLW5vZGVqcyQvKTtcblxuICAvLyBOb24gZXhpc3RpbmcgZmlsZVxuICBleHBlY3QoZmluZFVwKCdub24tZXhpc3RpbmctZmlsZS51bmtub3duJykpLnRvQmUodW5kZWZpbmVkKTtcblxuICAvLyBTdGFydGluZyBhdCBhIHNwZWNpZmljIHBhdGhcbiAgZXhwZWN0KGZpbmRVcCgndXRpbC50ZXN0LnRzJywgcGF0aC5qb2luKF9fZGlybmFtZSwgJ2ludGVnLWhhbmRsZXJzJykpKS50b01hdGNoKC9hd3MtbGFtYmRhLW5vZGVqc1xcL3Rlc3QkLyk7XG59KTtcbiJdfQ==