import * as lambda from '@aws-cdk/aws-lambda';
import * as logs from '@aws-cdk/aws-logs';
import { Construct } from '@aws-cdk/core';
/**
 * Use a Lamda Function as the destination for a log subscription.
 */
export declare class LambdaDestination implements logs.ILogSubscriptionDestination {
    private readonly fn;
    /**
     *
     */
    constructor(fn: lambda.IFunction);
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     */
    bind(scope: Construct, logGroup: logs.ILogGroup): logs.LogSubscriptionDestinationConfig;
}
