"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDestination = void 0;
const iam = require("@aws-cdk/aws-iam");
/**
 * Use a Kinesis stream as the destination for a log subscription.
 */
class KinesisDestination {
    /**
     *
     */
    constructor(stream) {
        this.stream = stream;
    }
    /**
     * Return the properties required to send subscription events to this destination.
     *
     * If necessary, the destination can use the properties of the SubscriptionFilter
     * object itself to configure its permissions to allow the subscription to write
     * to it.
     *
     * The destination may reconfigure its own permissions in response to this
     * function call.
     */
    bind(scope, _sourceLogGroup) {
        // Following example from https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/SubscriptionFilters.html#DestinationKinesisExample
        // Create a role to be assumed by CWL that can write to this stream and pass itself.
        const id = 'CloudWatchLogsCanPutRecords';
        const role = scope.node.tryFindChild(id) || new iam.Role(scope, id, {
            assumedBy: new iam.ServicePrincipal('logs.amazonaws.com'),
        });
        this.stream.grantWrite(role);
        role.grantPassRole(role);
        return { arn: this.stream.streamArn, role };
    }
}
exports.KinesisDestination = KinesisDestination;
//# sourceMappingURL=data:application/json;base64,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