"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ *
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
const app = new aws_cdk_lib_1.App();
// Empty arguments
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
const construct = new lib_1.IotToKinesisFirehoseToS3(stack, 'test-iot-kinesisfirehose-s3', {
    iotTopicRuleProps: {
        topicRulePayload: {
            ruleDisabled: false,
            description: "Persistent storage of connected vehicle telematics data",
            sql: "SELECT * FROM 'connectedcar/telemetry/#'",
            actions: []
        }
    },
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    },
    logS3AccessLogs: false
});
const s3Bucket = construct.s3Bucket;
defaults.addCfnSuppressRules(s3Bucket, [
    {
        id: 'W35',
        reason: 'This S3 bucket is created for unit/ integration testing purposes only.'
    },
]);
app.synth();
//# sourceMappingURL=data:application/json;base64,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