/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as kinesisfirehose from 'aws-cdk-lib/aws-kinesisfirehose';
import * as iot from 'aws-cdk-lib/aws-iot';
import * as s3 from 'aws-cdk-lib/aws-s3';
import * as iam from 'aws-cdk-lib/aws-iam';
import * as logs from 'aws-cdk-lib/aws-logs';
import { Construct } from 'constructs';
/**
 * @summary The properties for the IotToKinesisFirehoseToS3 Construct
 */
export interface IotToKinesisFirehoseToS3Props {
    /**
     * User provided CfnTopicRuleProps to override the defaults
     *
     * @default - Default props are used
     */
    readonly iotTopicRuleProps: iot.CfnTopicRuleProps;
    /**
     * Optional user provided props to override the default props
     *
     * @default - Default props are used
     */
    readonly kinesisFirehoseProps?: kinesisfirehose.CfnDeliveryStreamProps | any;
    /**
     * Existing instance of S3 Bucket object, providing both this and `bucketProps` will cause an error.
     *
     * @default - None
     */
    readonly existingBucketObj?: s3.IBucket;
    /**
     * User provided props to override the default props for the S3 Bucket.
     *
     * @default - Default props are used
     */
    readonly bucketProps?: s3.BucketProps;
    /**
     * User provided props to override the default props for the CloudWatchLogs LogGroup.
     *
     * @default - Default props are used
     */
    readonly logGroupProps?: logs.LogGroupProps;
    /**
     * Optional user provided props to override the default props for the S3 Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly loggingBucketProps?: s3.BucketProps;
    /**
     * Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
     * Enabling Access Logging is a best practice.
     *
     * @default - true
     */
    readonly logS3AccessLogs?: boolean;
}
export declare class IotToKinesisFirehoseToS3 extends Construct {
    readonly iotTopicRule: iot.CfnTopicRule;
    readonly kinesisFirehose: kinesisfirehose.CfnDeliveryStream;
    readonly kinesisFirehoseLogGroup: logs.LogGroup;
    readonly kinesisFirehoseRole: iam.Role;
    readonly s3Bucket?: s3.Bucket;
    readonly s3LoggingBucket?: s3.Bucket;
    readonly iotActionsRole: iam.Role;
    readonly s3BucketInterface: s3.IBucket;
    /**
     * @summary Constructs a new instance of the IotToKinesisFirehoseToS3 class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToApiGatewayProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope: Construct, id: string, props: IotToKinesisFirehoseToS3Props);
}
