"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomActionRegistration = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline_generated_1 = require("./codepipeline.generated");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("@aws-cdk/core");
/**
 * The resource representing registering a custom Action with CodePipeline.
 * For the Action to be usable, it has to be registered for every region and every account it's used in.
 * In addition to this class, you should most likely also provide your clients a class
 * representing your custom Action, extending the Action class,
 * and taking the `actionProperties` as properly typed, construction properties.
 */
class CustomActionRegistration extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_codepipeline_CustomActionRegistrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CustomActionRegistration);
            }
            throw error;
        }
        new codepipeline_generated_1.CfnCustomActionType(this, 'Resource', {
            category: props.category,
            inputArtifactDetails: {
                minimumCount: props.artifactBounds.minInputs,
                maximumCount: props.artifactBounds.maxInputs,
            },
            outputArtifactDetails: {
                minimumCount: props.artifactBounds.minOutputs,
                maximumCount: props.artifactBounds.maxOutputs,
            },
            provider: props.provider,
            version: props.version || '1',
            settings: {
                entityUrlTemplate: props.entityUrl,
                executionUrlTemplate: props.executionUrl,
            },
            configurationProperties: props.actionProperties?.map((ap) => {
                return {
                    key: ap.key || false,
                    secret: ap.secret || false,
                    ...ap,
                };
            }),
        });
    }
}
exports.CustomActionRegistration = CustomActionRegistration;
_a = JSII_RTTI_SYMBOL_1;
CustomActionRegistration[_a] = { fqn: "@aws-cdk/aws-codepipeline.CustomActionRegistration", version: "1.172.0" };
//# sourceMappingURL=data:application/json;base64,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