"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Choice = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const chain_1 = require("../chain");
const state_type_1 = require("./private/state-type");
const state_1 = require("./state");
/**
 * Define a Choice in the state machine
 *
 * A choice state can be used to make decisions based on the execution
 * state.
 */
class Choice extends state_1.State {
    constructor(scope, id, props = {}) {
        super(scope, id, props);
        this.endStates = [];
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_ChoiceProps(props);
    }
    /**
     * If the given condition matches, continue execution with the given state
     */
    when(condition, next) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_Condition(condition);
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(next);
        super.addChoice(condition, next.startState);
        return this;
    }
    /**
     * If none of the given conditions match, continue execution with the given state
     *
     * If no conditions match and no otherwise() has been given, an execution
     * error will be raised.
     */
    otherwise(def) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_IChainable(def);
        super.makeDefault(def.startState);
        return this;
    }
    /**
     * Return a Chain that contains all reachable end states from this Choice
     *
     * Use this to combine all possible choice paths back.
     */
    afterwards(options = {}) {
        jsiiDeprecationWarnings._aws_cdk_aws_stepfunctions_AfterwardsOptions(options);
        const endStates = state_1.State.filterNextables(state_1.State.findReachableEndStates(this, { includeErrorHandlers: options.includeErrorHandlers }));
        if (options.includeOtherwise && this.defaultChoice) {
            throw new Error(`'includeOtherwise' set but Choice state ${this.stateId} already has an 'otherwise' transition`);
        }
        if (options.includeOtherwise) {
            endStates.push(new DefaultAsNext(this));
        }
        return chain_1.Chain.custom(this, endStates, this);
    }
    /**
     * Return the Amazon States Language object for this state
     */
    toStateJson() {
        return {
            Type: state_type_1.StateType.CHOICE,
            Comment: this.comment,
            ...this.renderInputOutput(),
            ...this.renderChoices(),
        };
    }
}
exports.Choice = Choice;
_a = JSII_RTTI_SYMBOL_1;
Choice[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Choice", version: "1.145.0" };
/**
 * Adapter to make the .otherwise() transition settable through .next()
 */
class DefaultAsNext {
    constructor(choice) {
        this.choice = choice;
    }
    next(state) {
        this.choice.otherwise(state);
        return chain_1.Chain.sequence(this.choice, state);
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2hvaWNlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiY2hvaWNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBLG9DQUFpQztBQUdqQyxxREFBaUQ7QUFDakQsbUNBQWdDO0FBa0NoQzs7Ozs7R0FLRztBQUNILE1BQWEsTUFBTyxTQUFRLGFBQUs7SUFHL0IsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxRQUFxQixFQUFFO1FBQy9ELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBSFYsY0FBUyxHQUFnQixFQUFFLENBQUM7O0tBSTNDO0lBRUQ7O09BRUc7SUFDSSxJQUFJLENBQUMsU0FBb0IsRUFBRSxJQUFnQjs7O1FBQ2hELEtBQUssQ0FBQyxTQUFTLENBQUMsU0FBUyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUM1QyxPQUFPLElBQUksQ0FBQztLQUNiO0lBRUQ7Ozs7O09BS0c7SUFDSSxTQUFTLENBQUMsR0FBZTs7UUFDOUIsS0FBSyxDQUFDLFdBQVcsQ0FBQyxHQUFHLENBQUMsVUFBVSxDQUFDLENBQUM7UUFDbEMsT0FBTyxJQUFJLENBQUM7S0FDYjtJQUVEOzs7O09BSUc7SUFDSSxVQUFVLENBQUMsVUFBNkIsRUFBRTs7UUFDL0MsTUFBTSxTQUFTLEdBQUcsYUFBSyxDQUFDLGVBQWUsQ0FBQyxhQUFLLENBQUMsc0JBQXNCLENBQUMsSUFBSSxFQUFFLEVBQUUsb0JBQW9CLEVBQUUsT0FBTyxDQUFDLG9CQUFvQixFQUFFLENBQUMsQ0FBQyxDQUFDO1FBQ3BJLElBQUksT0FBTyxDQUFDLGdCQUFnQixJQUFJLElBQUksQ0FBQyxhQUFhLEVBQUU7WUFDbEQsTUFBTSxJQUFJLEtBQUssQ0FBQywyQ0FBMkMsSUFBSSxDQUFDLE9BQU8sd0NBQXdDLENBQUMsQ0FBQztTQUNsSDtRQUNELElBQUksT0FBTyxDQUFDLGdCQUFnQixFQUFFO1lBQzVCLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxhQUFhLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztTQUN6QztRQUNELE9BQU8sYUFBSyxDQUFDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsU0FBUyxFQUFFLElBQUksQ0FBQyxDQUFDO0tBQzVDO0lBRUQ7O09BRUc7SUFDSSxXQUFXO1FBQ2hCLE9BQU87WUFDTCxJQUFJLEVBQUUsc0JBQVMsQ0FBQyxNQUFNO1lBQ3RCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixHQUFHLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtZQUMzQixHQUFHLElBQUksQ0FBQyxhQUFhLEVBQUU7U0FDeEIsQ0FBQztLQUNIOztBQXBESCx3QkFxREM7OztBQTJCRDs7R0FFRztBQUNILE1BQU0sYUFBYTtJQUNqQixZQUE2QixNQUFjO1FBQWQsV0FBTSxHQUFOLE1BQU0sQ0FBUTtLQUMxQztJQUVNLElBQUksQ0FBQyxLQUFpQjtRQUMzQixJQUFJLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUM3QixPQUFPLGFBQUssQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsQ0FBQztLQUMzQztDQUNGIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBDaGFpbiB9IGZyb20gJy4uL2NoYWluJztcbmltcG9ydCB7IENvbmRpdGlvbiB9IGZyb20gJy4uL2NvbmRpdGlvbic7XG5pbXBvcnQgeyBJQ2hhaW5hYmxlLCBJTmV4dGFibGUgfSBmcm9tICcuLi90eXBlcyc7XG5pbXBvcnQgeyBTdGF0ZVR5cGUgfSBmcm9tICcuL3ByaXZhdGUvc3RhdGUtdHlwZSc7XG5pbXBvcnQgeyBTdGF0ZSB9IGZyb20gJy4vc3RhdGUnO1xuXG4vKipcbiAqIFByb3BlcnRpZXMgZm9yIGRlZmluaW5nIGEgQ2hvaWNlIHN0YXRlXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQ2hvaWNlUHJvcHMge1xuICAvKipcbiAgICogQW4gb3B0aW9uYWwgZGVzY3JpcHRpb24gZm9yIHRoaXMgc3RhdGVcbiAgICpcbiAgICogQGRlZmF1bHQgTm8gY29tbWVudFxuICAgKi9cbiAgcmVhZG9ubHkgY29tbWVudD86IHN0cmluZztcblxuICAvKipcbiAgICogSlNPTlBhdGggZXhwcmVzc2lvbiB0byBzZWxlY3QgcGFydCBvZiB0aGUgc3RhdGUgdG8gYmUgdGhlIGlucHV0IHRvIHRoaXMgc3RhdGUuXG4gICAqXG4gICAqIE1heSBhbHNvIGJlIHRoZSBzcGVjaWFsIHZhbHVlIERJU0NBUkQsIHdoaWNoIHdpbGwgY2F1c2UgdGhlIGVmZmVjdGl2ZVxuICAgKiBpbnB1dCB0byBiZSB0aGUgZW1wdHkgb2JqZWN0IHt9LlxuICAgKlxuICAgKiBAZGVmYXVsdCAkXG4gICAqL1xuICByZWFkb25seSBpbnB1dFBhdGg/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIEpTT05QYXRoIGV4cHJlc3Npb24gdG8gc2VsZWN0IHBhcnQgb2YgdGhlIHN0YXRlIHRvIGJlIHRoZSBvdXRwdXQgdG8gdGhpcyBzdGF0ZS5cbiAgICpcbiAgICogTWF5IGFsc28gYmUgdGhlIHNwZWNpYWwgdmFsdWUgRElTQ0FSRCwgd2hpY2ggd2lsbCBjYXVzZSB0aGUgZWZmZWN0aXZlXG4gICAqIG91dHB1dCB0byBiZSB0aGUgZW1wdHkgb2JqZWN0IHt9LlxuICAgKlxuICAgKiBAZGVmYXVsdCAkXG4gICAqL1xuICByZWFkb25seSBvdXRwdXRQYXRoPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIERlZmluZSBhIENob2ljZSBpbiB0aGUgc3RhdGUgbWFjaGluZVxuICpcbiAqIEEgY2hvaWNlIHN0YXRlIGNhbiBiZSB1c2VkIHRvIG1ha2UgZGVjaXNpb25zIGJhc2VkIG9uIHRoZSBleGVjdXRpb25cbiAqIHN0YXRlLlxuICovXG5leHBvcnQgY2xhc3MgQ2hvaWNlIGV4dGVuZHMgU3RhdGUge1xuICBwdWJsaWMgcmVhZG9ubHkgZW5kU3RhdGVzOiBJTmV4dGFibGVbXSA9IFtdO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDaG9pY2VQcm9wcyA9IHt9KSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogSWYgdGhlIGdpdmVuIGNvbmRpdGlvbiBtYXRjaGVzLCBjb250aW51ZSBleGVjdXRpb24gd2l0aCB0aGUgZ2l2ZW4gc3RhdGVcbiAgICovXG4gIHB1YmxpYyB3aGVuKGNvbmRpdGlvbjogQ29uZGl0aW9uLCBuZXh0OiBJQ2hhaW5hYmxlKTogQ2hvaWNlIHtcbiAgICBzdXBlci5hZGRDaG9pY2UoY29uZGl0aW9uLCBuZXh0LnN0YXJ0U3RhdGUpO1xuICAgIHJldHVybiB0aGlzO1xuICB9XG5cbiAgLyoqXG4gICAqIElmIG5vbmUgb2YgdGhlIGdpdmVuIGNvbmRpdGlvbnMgbWF0Y2gsIGNvbnRpbnVlIGV4ZWN1dGlvbiB3aXRoIHRoZSBnaXZlbiBzdGF0ZVxuICAgKlxuICAgKiBJZiBubyBjb25kaXRpb25zIG1hdGNoIGFuZCBubyBvdGhlcndpc2UoKSBoYXMgYmVlbiBnaXZlbiwgYW4gZXhlY3V0aW9uXG4gICAqIGVycm9yIHdpbGwgYmUgcmFpc2VkLlxuICAgKi9cbiAgcHVibGljIG90aGVyd2lzZShkZWY6IElDaGFpbmFibGUpOiBDaG9pY2Uge1xuICAgIHN1cGVyLm1ha2VEZWZhdWx0KGRlZi5zdGFydFN0YXRlKTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIC8qKlxuICAgKiBSZXR1cm4gYSBDaGFpbiB0aGF0IGNvbnRhaW5zIGFsbCByZWFjaGFibGUgZW5kIHN0YXRlcyBmcm9tIHRoaXMgQ2hvaWNlXG4gICAqXG4gICAqIFVzZSB0aGlzIHRvIGNvbWJpbmUgYWxsIHBvc3NpYmxlIGNob2ljZSBwYXRocyBiYWNrLlxuICAgKi9cbiAgcHVibGljIGFmdGVyd2FyZHMob3B0aW9uczogQWZ0ZXJ3YXJkc09wdGlvbnMgPSB7fSk6IENoYWluIHtcbiAgICBjb25zdCBlbmRTdGF0ZXMgPSBTdGF0ZS5maWx0ZXJOZXh0YWJsZXMoU3RhdGUuZmluZFJlYWNoYWJsZUVuZFN0YXRlcyh0aGlzLCB7IGluY2x1ZGVFcnJvckhhbmRsZXJzOiBvcHRpb25zLmluY2x1ZGVFcnJvckhhbmRsZXJzIH0pKTtcbiAgICBpZiAob3B0aW9ucy5pbmNsdWRlT3RoZXJ3aXNlICYmIHRoaXMuZGVmYXVsdENob2ljZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGAnaW5jbHVkZU90aGVyd2lzZScgc2V0IGJ1dCBDaG9pY2Ugc3RhdGUgJHt0aGlzLnN0YXRlSWR9IGFscmVhZHkgaGFzIGFuICdvdGhlcndpc2UnIHRyYW5zaXRpb25gKTtcbiAgICB9XG4gICAgaWYgKG9wdGlvbnMuaW5jbHVkZU90aGVyd2lzZSkge1xuICAgICAgZW5kU3RhdGVzLnB1c2gobmV3IERlZmF1bHRBc05leHQodGhpcykpO1xuICAgIH1cbiAgICByZXR1cm4gQ2hhaW4uY3VzdG9tKHRoaXMsIGVuZFN0YXRlcywgdGhpcyk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIHRoZSBBbWF6b24gU3RhdGVzIExhbmd1YWdlIG9iamVjdCBmb3IgdGhpcyBzdGF0ZVxuICAgKi9cbiAgcHVibGljIHRvU3RhdGVKc29uKCk6IG9iamVjdCB7XG4gICAgcmV0dXJuIHtcbiAgICAgIFR5cGU6IFN0YXRlVHlwZS5DSE9JQ0UsXG4gICAgICBDb21tZW50OiB0aGlzLmNvbW1lbnQsXG4gICAgICAuLi50aGlzLnJlbmRlcklucHV0T3V0cHV0KCksXG4gICAgICAuLi50aGlzLnJlbmRlckNob2ljZXMoKSxcbiAgICB9O1xuICB9XG59XG5cbi8qKlxuICogT3B0aW9ucyBmb3Igc2VsZWN0aW5nIHRoZSBjaG9pY2UgcGF0aHNcbiAqL1xuZXhwb3J0IGludGVyZmFjZSBBZnRlcndhcmRzT3B0aW9ucyB7XG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGluY2x1ZGUgZXJyb3IgaGFuZGxpbmcgc3RhdGVzXG4gICAqXG4gICAqIElmIHRoaXMgaXMgdHJ1ZSwgYWxsIHN0YXRlcyB3aGljaCBhcmUgZXJyb3IgaGFuZGxlcnMgKGFkZGVkIHRocm91Z2ggJ29uRXJyb3InKVxuICAgKiBhbmQgc3RhdGVzIHJlYWNoYWJsZSB2aWEgZXJyb3IgaGFuZGxlcnMgd2lsbCBiZSBpbmNsdWRlZCBhcyB3ZWxsLlxuICAgKlxuICAgKiBAZGVmYXVsdCBmYWxzZVxuICAgKi9cbiAgcmVhZG9ubHkgaW5jbHVkZUVycm9ySGFuZGxlcnM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBXaGV0aGVyIHRvIGluY2x1ZGUgdGhlIGRlZmF1bHQvb3RoZXJ3aXNlIHRyYW5zaXRpb24gZm9yIHRoZSBjdXJyZW50IENob2ljZSBzdGF0ZVxuICAgKlxuICAgKiBJZiB0aGlzIGlzIHRydWUgYW5kIHRoZSBjdXJyZW50IENob2ljZSBkb2VzIG5vdCBoYXZlIGEgZGVmYXVsdCBvdXRnb2luZ1xuICAgKiB0cmFuc2l0aW9uLCBvbmUgd2lsbCBiZSBhZGRlZCBpbmNsdWRlZCB3aGVuIC5uZXh0KCkgaXMgY2FsbGVkIG9uIHRoZSBjaGFpbi5cbiAgICpcbiAgICogQGRlZmF1bHQgZmFsc2VcbiAgICovXG4gIHJlYWRvbmx5IGluY2x1ZGVPdGhlcndpc2U/OiBib29sZWFuO1xufVxuXG4vKipcbiAqIEFkYXB0ZXIgdG8gbWFrZSB0aGUgLm90aGVyd2lzZSgpIHRyYW5zaXRpb24gc2V0dGFibGUgdGhyb3VnaCAubmV4dCgpXG4gKi9cbmNsYXNzIERlZmF1bHRBc05leHQgaW1wbGVtZW50cyBJTmV4dGFibGUge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGNob2ljZTogQ2hvaWNlKSB7XG4gIH1cblxuICBwdWJsaWMgbmV4dChzdGF0ZTogSUNoYWluYWJsZSk6IENoYWluIHtcbiAgICB0aGlzLmNob2ljZS5vdGhlcndpc2Uoc3RhdGUpO1xuICAgIHJldHVybiBDaGFpbi5zZXF1ZW5jZSh0aGlzLmNob2ljZSwgc3RhdGUpO1xuICB9XG59XG4iXX0=