"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InputType = exports.TaskInput = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fields_1 = require("./fields");
/**
 * Type union for task classes that accept multiple types of payload
 */
class TaskInput {
    /**
     *
     * @param type type of task input
     * @param value payload for the corresponding input type.
     * It can be a JSON-encoded object, context, data, etc.
     */
    constructor(type, value) {
        this.type = type;
        this.value = value;
    }
    /**
     * Use a literal string as task input
     *
     * This might be a JSON-encoded object, or just a text.
     */
    static fromText(text) {
        return new TaskInput(InputType.TEXT, text);
    }
    /**
     * Use an object as task input
     *
     * This object may contain JSON path fields as object values, if desired.
     */
    static fromObject(obj) {
        return new TaskInput(InputType.OBJECT, obj);
    }
    /**
     * Use a part of the execution data or task context as task input
     *
     * Use this when you want to use a subobject or string from
     * the current state machine execution or the current task context
     * as complete payload to a task.
     */
    static fromJsonPathAt(path) {
        return new TaskInput(InputType.TEXT, fields_1.JsonPath.stringAt(path));
    }
    /**
     * Use a part of the execution data as task input
     *
     * Use this when you want to use a subobject or string from
     * the current state machine execution as complete payload
     * to a task.
     *
     * @deprecated Use `fromJsonPathAt`.
     */
    static fromDataAt(path) {
        jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions.TaskInput#fromDataAt", "Use `fromJsonPathAt`.");
        return new TaskInput(InputType.TEXT, fields_1.JsonPath.stringAt(path));
    }
    /**
     * Use a part of the task context as task input
     *
     * Use this when you want to use a subobject or string from
     * the current task context as complete payload
     * to a task.
     *
     * @deprecated Use `fromJsonPathAt`.
     */
    static fromContextAt(path) {
        jsiiDeprecationWarnings.print("@aws-cdk/aws-stepfunctions.TaskInput#fromContextAt", "Use `fromJsonPathAt`.");
        return new TaskInput(InputType.TEXT, fields_1.JsonPath.stringAt(path));
    }
}
exports.TaskInput = TaskInput;
_a = JSII_RTTI_SYMBOL_1;
TaskInput[_a] = { fqn: "@aws-cdk/aws-stepfunctions.TaskInput", version: "1.145.0" };
/**
 * The type of task input
 */
var InputType;
(function (InputType) {
    /**
     * Use a literal string
     * This might be a JSON-encoded object, or just text.
     * valid JSON text: standalone, quote-delimited strings; objects; arrays; numbers; Boolean values; and null.
     *
     * example: `literal string`
     * example: {"json": "encoded"}
     */
    InputType[InputType["TEXT"] = 0] = "TEXT";
    /**
     * Use an object which may contain Data and Context fields
     * as object values, if desired.
     *
     * example:
     * {
     *  literal: 'literal',
     *  SomeInput: sfn.JsonPath.stringAt('$.someField')
     * }
     *
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/concepts-state-machine-data.html
     * @see https://docs.aws.amazon.com/step-functions/latest/dg/input-output-contextobject.html
     */
    InputType[InputType["OBJECT"] = 1] = "OBJECT";
})(InputType = exports.InputType || (exports.InputType = {}));
//# sourceMappingURL=data:application/json;base64,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