# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['agileupstate']

package_data = \
{'': ['*']}

install_requires = \
['PyYAML>=5.4.1,<6.0.0',
 'click>=8.1,<9.0',
 'hvac>=1.0.2,<2.0.0',
 'prettytable>=3.3.0,<4.0.0',
 'pywinrm>=0.4.3,<0.5.0']

entry_points = \
{'console_scripts': ['agileupstate = agileupstate.cli:cli']}

setup_kwargs = {
    'name': 'agileupstate',
    'version': '0.0.42',
    'description': 'State mangement tool for Future Agile CICD',
    'long_description': '# agileupstate\n\nPython 3.8+ project to manage AgileUP pipeline states with the following features:\n\n* Linux and Windows compatible project.\n* Defines state model.\n* Saves and fetches states from vault.\n* Exports private key for Linux SSH connections.\n* Exports client PKI data for Windows WinRM connections.\n* Exports cloud init zip file for mTLS connection data to Windows WinRM hosts.\n* Exports ansible inventories for both Linux(SSH) and Windows(WinRM) connections.\n* Provides simple connectivity tests.\n\n## Prerequisites\n\nThis project uses poetry is a tool for dependency management and packaging in Python. It allows you to declare the \nlibraries your project depends on, it will manage (install/update) them for you. \n\nUse the installer rather than pip [installing-with-the-official-installer](https://python-poetry.org/docs/master/#installing-with-the-official-installer).\n\n```sh\npoetry self add poetry-bumpversion\n```\n\n```sh\npoetry -V\nPoetry (version 1.2.0)\n```\n\n### Windows Path\n\nInstall poetry from powershell in admin mode.\n\n```shell\n(Invoke-WebRequest -Uri https://install.python-poetry.org -UseBasicParsing).Content | py -\n```\n\nThe path will be `C:\\Users\\<YOURUSER>\\AppData\\Roaming\\Python\\Scripts\\poetry.exe` which you will need to add to your system path.\n\n### Windows GitBash\n\nWhen using gitbash you can setup an alias for the poetry command:\n\n```shell\nalias poetry="\\"C:\\Users\\<YOURUSER>\\AppData\\Roaming\\Python\\Scripts\\poetry.exe\\""\n```\n\n## Getting Started\n\n```sh\npoetry update\n```\n\n```sh\npoetry install\n```\n\n## Development\n\nThis project uses the [hvac](https://github.com/hvac/hvac) python module and to develop locally you can run vault\nas a docker service as detailed here [local docker vault](https://hub.docker.com/_/vault). For local development vault \nsetup follow the [VAULT](VAULT.md) guide for information.\n\nCheck your connection with the following command, note in development mode vault should not be sealed.\n\n```shell\nexport VAULT_ADDR=\'http://localhost:8200\'\nexport VAULT_TOKEN=\'8d02106e-b1cd-4fa5-911b-5b4e669ad07a\'\n\npoetry run agileupstate check\n```\n\n## States\n\n* The state values are exported to `siab-state.yml`.\n* The dynamic state names used by terraform are exported to file `siab-state-names.sh` and should be sourced in the pipelines for correct use.\n* The tarraform state file is exported as `terraform.tfstate`.\n\n## Cloud Init\n\n```shell\npoetry run agileupstate cloud-init --server-path=siab-pfx/ags-w-arm1.meltingturret.io.pfx --client-path=siab-pfx/devops@meltingturret.io.pfx\n```\n\n## Ansible Inventory\n\nThe ansible `inventory.txt` file is generated from the state data and the format automatically supports both SSH and \nWinRM connections. It is assumed that terraform does not output `[\'vm-rsa-private-key\']` for Windows hosts which is used to determine \nthe difference ebtween SSH or WinRM type inventory.txt file, example of WinRM file:\n\nExample SSH `inventory.txt`\n```ini\n[001_arm_uksouth_dev]\n20.77.124.22 ansible_ssh_private_key_file=vm-rsa-private-key.pem\n```\n\nExample WinRM `inventory.txt`\n```ini\n[001_arm_uksouth_dev]\n20.108.1.34\n[001_arm_uksouth_dev:vars]\nansible_user=azureuser\nansible_password=heTgDg!J4buAv5kc\nansible_connection=winrm\nansible_port=5986\nansible_winrm_ca_trust_path=chain.meltingturret.io.pem\nansible_winrm_cert_pem=devops@meltingturret.io.pem\nansible_winrm_cert_key_pem=devops@meltingturret.io.key\nansible_winrm_transport=certificate\n```\n\n## Run\n```sh\npoetry run agileupstate\n```\n\n## Lint\n```sh\npoetry run flake8\n```\n\n## Test\n```sh\npoetry run pytest\n```\n\n## Publish\n\n* By default we are using [PYPI packages](https://packaging.python.org/en/latest/tutorials/installing-packages/). \n* Create yourself an access token for PYPI and then follow the instructions.\n\n```sh\nexport PYPI_USERNAME=__token__ \nexport PYPI_PASSWORD=<Your API Token>\npoetry publish --build --username $PYPI_USERNAME --password $PYPI_PASSWORD\n```\n\n## Versioning\nWe use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/Agile-Solutions-GB-Ltd/agileup/tags). \n\n## Releasing\n\nWe are using [poetry-bumpversion](https://github.com/monim67/poetry-bumpversion) to manage release versions.\n\n```sh\npoetry version patch\n```\n\n## Dependency\n\nOnce the release has been created it is now available for you to use in other python projects via:\n\n```sh\npip install agileupstate\n```\n\nAnd also for poetry projects via:\n\n```sh\npoetry add agileupstate\n```\n\n## Contributing\n\nPlease read [CONTRIBUTING.md](CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.\n\n## License\n\nThis project is licensed under the Apache License, Version 2.0 - see the [LICENSE](LICENSE) file for details\n\n\n\n',
    'author': 'agileturret',
    'author_email': 'Paul.Gilligan@agilesolutions.co.uk',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/Agile-Solutions-GB-Ltd/agileupstate',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
