"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiEventSource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const apigw = require("@aws-cdk/aws-apigateway");
const core_1 = require("@aws-cdk/core");
class ApiEventSource {
    constructor(method, path, options) {
        this.method = method;
        this.path = path;
        this.options = options;
        if (!path.startsWith('/')) {
            throw new Error(`Path must start with "/": ${path}`);
        }
    }
    bind(target) {
        const id = `${core_1.Names.nodeUniqueId(target.node)}:ApiEventSourceA7A86A4F`;
        const stack = core_1.Stack.of(target);
        let api = stack.node.tryFindChild(id);
        if (!api) {
            api = new apigw.RestApi(stack, id, {
                defaultIntegration: new apigw.LambdaIntegration(target),
            });
        }
        const resource = api.root.resourceForPath(this.path);
        resource.addMethod(this.method, undefined, this.options);
    }
}
exports.ApiEventSource = ApiEventSource;
_a = JSII_RTTI_SYMBOL_1;
ApiEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.ApiEventSource", version: "1.176.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXBpLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYXBpLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsaURBQWlEO0FBRWpELHdDQUE2QztBQUU3QyxNQUFhLGNBQWM7SUFDekIsWUFBNkIsTUFBYyxFQUFtQixJQUFZLEVBQW1CLE9BQTZCO1FBQTdGLFdBQU0sR0FBTixNQUFNLENBQVE7UUFBbUIsU0FBSSxHQUFKLElBQUksQ0FBUTtRQUFtQixZQUFPLEdBQVAsT0FBTyxDQUFzQjtRQUN4SCxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsRUFBRTtZQUN6QixNQUFNLElBQUksS0FBSyxDQUFDLDZCQUE2QixJQUFJLEVBQUUsQ0FBQyxDQUFDO1NBQ3REO0tBQ0Y7SUFFTSxJQUFJLENBQUMsTUFBd0I7UUFDbEMsTUFBTSxFQUFFLEdBQUcsR0FBRyxZQUFLLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUM7UUFDdkUsTUFBTSxLQUFLLEdBQUcsWUFBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUMvQixJQUFJLEdBQUcsR0FBRyxLQUFLLENBQUMsSUFBSSxDQUFDLFlBQVksQ0FBQyxFQUFFLENBQWtCLENBQUM7UUFDdkQsSUFBSSxDQUFDLEdBQUcsRUFBRTtZQUNSLEdBQUcsR0FBRyxJQUFJLEtBQUssQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtnQkFDakMsa0JBQWtCLEVBQUUsSUFBSSxLQUFLLENBQUMsaUJBQWlCLENBQUMsTUFBTSxDQUFDO2FBQ3hELENBQUMsQ0FBQztTQUNKO1FBRUQsTUFBTSxRQUFRLEdBQUcsR0FBRyxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDO1FBQ3JELFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQzFEOztBQW5CSCx3Q0FvQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBhcGlndyBmcm9tICdAYXdzLWNkay9hd3MtYXBpZ2F0ZXdheSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBOYW1lcywgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGNsYXNzIEFwaUV2ZW50U291cmNlIGltcGxlbWVudHMgbGFtYmRhLklFdmVudFNvdXJjZSB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgbWV0aG9kOiBzdHJpbmcsIHByaXZhdGUgcmVhZG9ubHkgcGF0aDogc3RyaW5nLCBwcml2YXRlIHJlYWRvbmx5IG9wdGlvbnM/OiBhcGlndy5NZXRob2RPcHRpb25zKSB7XG4gICAgaWYgKCFwYXRoLnN0YXJ0c1dpdGgoJy8nKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKGBQYXRoIG11c3Qgc3RhcnQgd2l0aCBcIi9cIjogJHtwYXRofWApO1xuICAgIH1cbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHRhcmdldDogbGFtYmRhLklGdW5jdGlvbik6IHZvaWQge1xuICAgIGNvbnN0IGlkID0gYCR7TmFtZXMubm9kZVVuaXF1ZUlkKHRhcmdldC5ub2RlKX06QXBpRXZlbnRTb3VyY2VBN0E4NkE0RmA7XG4gICAgY29uc3Qgc3RhY2sgPSBTdGFjay5vZih0YXJnZXQpO1xuICAgIGxldCBhcGkgPSBzdGFjay5ub2RlLnRyeUZpbmRDaGlsZChpZCkgYXMgYXBpZ3cuUmVzdEFwaTtcbiAgICBpZiAoIWFwaSkge1xuICAgICAgYXBpID0gbmV3IGFwaWd3LlJlc3RBcGkoc3RhY2ssIGlkLCB7XG4gICAgICAgIGRlZmF1bHRJbnRlZ3JhdGlvbjogbmV3IGFwaWd3LkxhbWJkYUludGVncmF0aW9uKHRhcmdldCksXG4gICAgICB9KTtcbiAgICB9XG5cbiAgICBjb25zdCByZXNvdXJjZSA9IGFwaS5yb290LnJlc291cmNlRm9yUGF0aCh0aGlzLnBhdGgpO1xuICAgIHJlc291cmNlLmFkZE1ldGhvZCh0aGlzLm1ldGhvZCwgdW5kZWZpbmVkLCB0aGlzLm9wdGlvbnMpO1xuICB9XG59XG4iXX0=