from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.0.13'
DESCRIPTION = 'Simple PDF editing made fast'
LONG_DESCRIPTION = 'A package that allows to manipulate PDF pages as you would do with lists based on PyPDF2.'

# Setting up
setup(
    name="PDFpy",
    version=VERSION,
    author="Jonas Ha",
    author_email="<jonasharriehausen@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['PyPDF2'],
    keywords=['python', 'PDF', 'PDFpy'],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)