"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotToKinesisFirehoseToS3 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iot = require("aws-cdk-lib/aws-iot");
const iam = require("aws-cdk-lib/aws-iam");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const core_1 = require("@aws-solutions-constructs/core");
const aws_kinesisfirehose_s3_1 = require("@aws-solutions-constructs/aws-kinesisfirehose-s3");
class IotToKinesisFirehoseToS3 extends constructs_1.Construct {
    /**
     * @summary Constructs a new instance of the IotToKinesisFirehoseToS3 class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {CloudFrontToApiGatewayProps} props - user provided props for the construct
     * @since 0.8.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        const firehoseToS3 = new aws_kinesisfirehose_s3_1.KinesisFirehoseToS3(this, 'KinesisFirehoseToS3', {
            kinesisFirehoseProps: props.kinesisFirehoseProps,
            existingBucketObj: props.existingBucketObj,
            bucketProps: props.bucketProps,
            logGroupProps: props.logGroupProps,
            loggingBucketProps: props.loggingBucketProps,
            logS3AccessLogs: props.logS3AccessLogs
        });
        this.kinesisFirehose = firehoseToS3.kinesisFirehose;
        this.s3Bucket = firehoseToS3.s3Bucket;
        this.s3BucketInterface = firehoseToS3.s3BucketInterface;
        // Setup the IAM Role for IoT Actions
        this.iotActionsRole = new iam.Role(this, 'IotActionsRole', {
            assumedBy: new iam.ServicePrincipal('iot.amazonaws.com'),
        });
        // Setup the IAM policy for IoT Actions
        const iotActionsPolicy = new iam.Policy(this, 'IotActionsPolicy', {
            statements: [new iam.PolicyStatement({
                    actions: [
                        'firehose:PutRecord'
                    ],
                    resources: [this.kinesisFirehose.attrArn]
                })
            ]
        });
        // Attach policy to role
        iotActionsPolicy.attachToRole(this.iotActionsRole);
        const defaultIotTopicProps = defaults.DefaultCfnTopicRuleProps([{
                firehose: {
                    deliveryStreamName: this.kinesisFirehose.ref,
                    roleArn: this.iotActionsRole.roleArn
                }
            }]);
        const iotTopicProps = core_1.overrideProps(defaultIotTopicProps, props.iotTopicRuleProps, true);
        // Create the IoT topic rule
        this.iotTopicRule = new iot.CfnTopicRule(this, 'IotTopic', iotTopicProps);
        this.kinesisFirehoseRole = firehoseToS3.kinesisFirehoseRole;
        this.s3LoggingBucket = firehoseToS3.s3LoggingBucket;
        this.kinesisFirehoseLogGroup = firehoseToS3.kinesisFirehoseLogGroup;
    }
}
exports.IotToKinesisFirehoseToS3 = IotToKinesisFirehoseToS3;
_a = JSII_RTTI_SYMBOL_1;
IotToKinesisFirehoseToS3[_a] = { fqn: "@aws-solutions-constructs/aws-iot-kinesisfirehose-s3.IotToKinesisFirehoseToS3", version: "2.32.0" };
//# sourceMappingURL=data:application/json;base64,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